package com.instabug.bug.utils

import android.content.Context
import com.instabug.library.internal.storage.DiskUtils

object BugUtils {

    private const val BUG_REPORTING_DIRECTORY = "bug_reporting"

    @JvmStatic
    fun getBugAttachmentFolder(context: Context?, bugId: String?): String? {
        bugId?.let { id ->
            context?.let { ctx ->
                return ("${DiskUtils.getInstabugInternalDirectory(ctx).absolutePath}/$BUG_REPORTING_DIRECTORY/Bug_$id/")
            }
        }
        return null
    }
}