package com.instabug.bug.settings;

import android.content.Context;
import android.text.Spanned;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.bug.Constants;
import com.instabug.bug.extendedbugreport.ExtendedBugReport;
import com.instabug.bug.model.ExtraReportField;
import com.instabug.bug.model.ReportCategory;
import com.instabug.bug.onboardingbugreporting.State;
import com.instabug.library.Feature;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.internal.video.customencoding.VideoEncoderConfig;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mohamedzakaria on 6/6/17.
 */

public class BugSettings {

    @Nullable
    private static BugSettings settingsManager;

    private BugSettings() {
    }

    public static void init(Context context) {
        settingsManager = new BugSettings();
        PersistableSettings.init(context);
    }

    /**
     * Returns the current singleton instance of this class.
     *
     * @return a {@code BugSettings} instance
     */
    public static BugSettings getInstance() {
        if (settingsManager == null) {
            settingsManager = new BugSettings();
        }
        return settingsManager;
    }

    public static void release() {
        PerSessionSettings.release();
        PersistableSettings.release();
        settingsManager = null;
    }

    @Nullable
    public List<ReportCategory> getReportCategories() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return null;
        return perSessionSettings.getReportCategories();
    }

    public void setReportCategories(List<ReportCategory> bugCategories) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setReportCategories(bugCategories);
        }
    }

    @Nullable
    public String getRemoteReportCategories() {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings == null) return null;
        return persistableSettings.getRemoteReportCategories();
    }

    public void setRemoteReportCategories(@Nullable String remoteReportCategories) {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings != null) {
            persistableSettings.setRemoteReportCategories(remoteReportCategories);
        }
    }

    public AttachmentsTypesParams getAttachmentsTypesParams() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return new AttachmentsTypesParams();
        return perSessionSettings.getAttachmentsTypesParams();
    }

    public void setAttachmentsTypesParams(AttachmentsTypesParams attachmentsTypesParams) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setAttachmentsTypesParams(attachmentsTypesParams);
        }
    }

    public boolean isAddAttachmentsButtonEnable() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return true;
        return perSessionSettings.getAttachmentsTypesParams()
                .isAllowTakeExtraScreenshot()
                || perSessionSettings.getAttachmentsTypesParams()
                .isAllowAttachImageFromGallery()
                || perSessionSettings.getAttachmentsTypesParams()
                .isAllowScreenRecording();
    }

    public boolean isEmailFieldRequired() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return true;
        return perSessionSettings.isEmailFieldRequired();
    }

    public void setEmailFieldRequired(boolean required) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setEmailFieldRequired(required);
        }
    }

    @Nullable
    public Runnable getPreReportRunnable() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return null;
        return perSessionSettings.getPreReportRunnable();
    }

    /**
     * Set a pre-report runnable. <br/>
     * WARNING: This runs on your application's main UI thread. Please do not include any
     * blocking operations to avoid ANRs.
     *
     * @param runnable This runnable is run on the UI thread before a bug report/feedback is
     *                 uploaded to the dashboard
     */
    public void setPreReportRunnable(Runnable runnable) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setPreReportRunnable(runnable);
        }
    }

    public boolean isEmailFieldVisible() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return true;
        return perSessionSettings.isEmailFieldVisible();
    }

    @Nullable
    public OnSdkDismissCallback getOnSdkDismissCallback() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return null;
        return perSessionSettings.getOnSdkDismissCallback();
    }

    public void setOnSdkDismissCallback(OnSdkDismissCallback onSdkDismissedCallback) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setOnSdkDismissCallback(onSdkDismissedCallback);
        }
    }

    public void setEmailFieldVisibility(boolean enabled) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setEmailFieldVisibility(enabled);
        }
    }

    public boolean isCommentFieldRequired() {
        PerSessionSettings persistableSettings = PerSessionSettings.getInstance();
        if (persistableSettings == null) return false;
        return persistableSettings.isCommentFieldRequired();
    }

    public void setCommentFieldRequired(boolean commentFieldRequired) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setCommentFieldRequired(commentFieldRequired);
        }
    }

    public long getLastBugTime() {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings == null) return 0L;
        return persistableSettings.getLastBugTime();
    }

    public void setLastBugTime(long time) {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings != null) {
            persistableSettings.setLastBugTime(time);
        }
    }

    public boolean successDialogEnabled() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return true;
        return perSessionSettings.successDialogEnabled();
    }

    public void setSuccessDialogEnabled(boolean shouldShowSuccessDialog) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setSuccessDialogEnabled(shouldShowSuccessDialog);
        }
    }

    @Nullable
    public Spanned getDisclaimerText() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return null;
        return perSessionSettings.getDisclaimerText();
    }

    public void setDisclaimerText(@Nullable Spanned disclaimerSpanned) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setDisclaimerText(disclaimerSpanned);
        }
    }

    public void addExtraReportField(CharSequence fieldHint, boolean required) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.addExtraReportField(fieldHint, required);
        }
    }

    public void clearExtraReportFields() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            PerSessionSettings.getInstance().clearExtraReportFields();
        }
    }

    public List<ExtraReportField> getExtraReportFields() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return new ArrayList<>();
        return perSessionSettings.getExtraReportFields();
    }

    public boolean isScreenshotRequired() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return false;
        return perSessionSettings.isScreenshotRequired();
    }

    public void setScreenshotRequired(boolean screenshotRequired) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setScreenshotRequired(screenshotRequired);
        }
    }

    public ExtendedBugReport.State getExtendedBugReportState() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return ExtendedBugReport.State.DISABLED;
        return perSessionSettings.getExtendedBugReportState();
    }

    public void setExtendedBugReportState(ExtendedBugReport.State state) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setExtendedBugReportState(state);
        }
    }

    public void setExtendedBugReportHints(@Nullable String hint1, @Nullable String hint2, @Nullable String hint3) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setExtendedBugReportHints(hint1, hint2, hint3);
        }
    }

    @Nullable
    public String getExtendedBugReportHint1() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            return perSessionSettings.getExtendedBugReportHint1();
        }
        return null;
    }

    @Nullable
    public String getExtendedBugReportHint2() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            return perSessionSettings.getExtendedBugReportHint2();
        }
        return null;
    }

    @Nullable
    public String getExtendedBugReportHint3() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            return perSessionSettings.getExtendedBugReportHint3();
        }
        return null;
    }

    public long getReportCategoriesLastFetchedTime() {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings != null) {
            return persistableSettings.getReportCategoriesLastFetchedTime();
        }
        return 0L;
    }

    public void setReportCategoriesLastFetchedTime(long time) {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings != null) {
            persistableSettings.setReportCategoriesLastFetchedTime(time);
        }
    }

    public void setBugReportingState(Feature.State state) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            perSessionSettings.setBugReportingState(state);
        }
    }

    public boolean isBugReportingStateEnabled() {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return false;
        return perSessionSettings.isBugReportingStateEnabled();
    }


    /**
     * A method to customize prompt options
     *
     * @param reportType one of {@link com.instabug.bug.BugReporting.ReportType}
     * @param status     new status
     */
    public void setReportTypeStatus(@Constants.ReportType String reportType, boolean status) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null) {
            PerSessionSettings.getInstance().setReportTypeStatus(reportType, status);
        }
    }


    /**
     * A method to customize prompt options
     *
     * @param reportType one of {@link com.instabug.bug.BugReporting.ReportType}
     * @return report status true if enabled, false otherwise.
     */
    public boolean getReportTypeStatus(@Constants.ReportType String reportType) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings == null) return false;
        return perSessionSettings.getReportTypeStatus(reportType);
    }

    public boolean isFirstRunAfterEncryptorUpdate() {
        if (PersistableSettings.getInstance() == null) return true;
        return PersistableSettings.getInstance().isFirstRunAfterEncryptorUpdate();
    }

    public void setFirstRunAfterEncryptorUpdate(boolean isFirstRun) {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings != null) {
            PersistableSettings.getInstance().setFirstRunAfterEncryptorUpdate(isFirstRun);
        }
    }

    public void setDbEncryptionMigrationStatus(boolean status) {
        PersistableSettings persistableSettings = PersistableSettings.getInstance();
        if (persistableSettings != null) {
            PersistableSettings.getInstance().setDbEncryptionMigrationStatus(status);
        }
    }

    public boolean getDbEncryptionMigrationStatus() {
        if (PersistableSettings.getInstance() == null) return true;
        return PersistableSettings.getInstance().getDbEncryptionMigrationStatus();
    }

    public void setReportTypeCommentMinCharLimit(@Constants.ReportType String reportType, int limit) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        if (perSessionSettings != null)
            perSessionSettings.setReportTypeCommentMinCharLimit(reportType, limit);
    }

    public int getReportTypeCommentMinCharLimit(@Constants.ReportType String reportType) {
        PerSessionSettings perSessionSettings = PerSessionSettings.getInstance();
        return perSessionSettings != null ?
                perSessionSettings.getReportTypeMinCommentCharLimit(reportType) : 0;
    }

   public void setWelcomeMessageState(@State int welcomeMessageState) {
       PerSessionSettings.getInstance().setWelcomeScreenState(welcomeMessageState);
   }
   @State
   public int getWelcomeMessageState() {
       int state = PerSessionSettings.getInstance().getWelcomeScreenState();
       switch (state) {
           case State.BETA:
               return State.BETA;
           case State.LIVE:
               return State.LIVE;
           case State.DISABLED:
               return State.DISABLED;
           default:
               return State.DISABLED;
       }
   }
    public static void setVideoEncoderConfig(@NonNull final VideoEncoderConfig config) {
        PerSessionSettings.getInstance().setVideoEncoderConfig(config);
    }

    @Nullable
    public static VideoEncoderConfig getVideoEncoderConfig() {
        return PerSessionSettings.getInstance().getVideoEncoderConfig();
    }

}
