package com.instabug.bug.preferences

import android.content.SharedPreferences
import com.instabug.library.Instabug
import com.instabug.library.util.nullRetryLazy
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.internal.sharedpreferences.PreferencesProperty
import java.util.concurrent.TimeUnit

typealias PrefSpec<T> = Pair<String, T>

private const val IBG_BUGS_PREF_FILE = "instabug_bug_reporting"

val bugsPreferences by nullRetryLazy {
    Instabug.getApplicationContext()
        ?.let { ctx -> CoreServiceLocator.getInstabugSharedPreferences(ctx, IBG_BUGS_PREF_FILE) }
}

class BugsPrefProperty<T>(key: String, defaultValue: T) :
    PreferencesProperty<T>(key, defaultValue) {
    override val pref: SharedPreferences?
        get() = bugsPreferences
}

fun <T> bugsPref(keyValue: PrefSpec<T>) = BugsPrefProperty(keyValue.first, keyValue.second)

object PrefSpecs {
    val ReproAttachmentsAvailability: PrefSpec<Boolean> = PrefSpec("bugs_rsa_availability", true)
    val LastFetchedLocale: PrefSpec<String> = PrefSpec("bugs_last_fetched_locale", "")
    val ProactiveReportingAvailability: PrefSpec<Boolean> =
        PrefSpec("proactive_reporting_enabled", true)
    val ShouldDropLogs: PrefSpec<Boolean> = PrefSpec("drop_state_logs", true)
    val ModalsGap: PrefSpec<Long> =
        PrefSpec("gap_between_modals_seconds", TimeUnit.HOURS.toSeconds(24))
    val DetectionGap: PrefSpec<Long> = PrefSpec("modal_delay_after_detection_seconds", 2)
    val LastModalTime: PrefSpec<Long> = PrefSpec("last_modal_time_millis", 0)
}