package com.instabug.bug.invocation.invoker;

import android.annotation.SuppressLint;
import android.content.Context;

import com.instabug.library.Constants;
import com.instabug.bug.invocation.InvocationListener;
import com.instabug.bug.invocation.InvocationManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.bug.invocation.util.ShakeDetector;
import com.instabug.library.util.threading.PoolProvider;


public class ShakeInvoker implements AbstractInvoker<Void>, ShakeDetector.OnShakeDetectedListener {

    private ShakeDetector shakeDetector;
    private InvocationListener invocationListener;
    private volatile boolean active;

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public ShakeInvoker(Context context, InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
        shakeDetector = new ShakeDetector(context,this);
    }

    @Override
    public void listen() {
        shakeDetector.start();
        active = true;
        InstabugSDKLogger.d(Constants.LOG_TAG, "Shake invoker: listen");
    }

    @Override
    public void sleep() {
        shakeDetector.stop();
        active = false;
        InstabugSDKLogger.d(Constants.LOG_TAG, "Shake invoker: sleep");
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void handle(Void action) {
    }

    @Override
    public void onShakeDetected() {
        PoolProvider.postIOTask(() -> {
            InstabugSDKLogger.d(Constants.LOG_TAG, "Shake detected, invoking SDK");
            InvocationManager.getInstance().setLastUsedInvoker(this);
            invocationListener.onInvocationRequested();
        });
    }

    public void setShakingThreshold(int threshold) {
        shakeDetector.setAccelerationThreshold(threshold);
    }

}
