package com.instabug.bug.invocation

import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable

internal interface InvocationManagerSubscribers {
    /**
     * Subscribe to different events that {InvocationManager} class need to react on it.
     */
    fun subscribe()

    /**
     * Release and clear subscribers
     */
    fun unsubscribe()
}

/**
 * InvocationManagerSubscribers actual implementation.
 * @param callback that will be invoked based on events trigger.
 * TODO: callback type should be replaced later by an interface that implemented by InvocationManager in order to depend on abstract not impl.
 */
internal class InvocationManagerSubscribersImpl(
    private val callback: InvocationManager?
) : InvocationManagerSubscribers {

    internal var sdkSessionEventsDisposable: IBGDisposable? = null
        private set

    override fun subscribe() {
        if (sdkSessionEventsDisposable != null)
            return

        subscribeToSdkSession()
    }

    /**
     * Respect SDK session state in order to make sure that all invokers are only listening
     * to invocations when the sdk session is running or sleeping otherwise.
     */
    private fun subscribeToSdkSession() {
        sdkSessionEventsDisposable = IBGCoreEventSubscriber
            .subscribe { sdkCoreEvent ->
                if (sdkCoreEvent is IBGSdkCoreEvent.Session) handleSessionEvent(sdkCoreEvent)
            }
    }

    private fun handleSessionEvent(sdkCoreEvent: IBGSdkCoreEvent.Session) {
        when (sdkCoreEvent) {
            IBGSdkCoreEvent.Session.SessionStarted -> callback?.listen()
            IBGSdkCoreEvent.Session.SessionFinished -> callback?.sleep()
        }
    }

    override fun unsubscribe() {
        sdkSessionEventsDisposable?.dispose()
        sdkSessionEventsDisposable = null
    }

}