package com.instabug.chat.settings;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;

import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;

import com.instabug.library.Feature;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;


public class ChatSettings {

    private static final String INSTABUG_CHAT_SHARED_PREF_NAME = "instabug_chat";

    public static void init(Context context) {
        PersistableSettings.init(getChatSharedPreferences(context));
    }

    @Nullable
    public static SharedPreferences getChatSharedPreferences(Context context) {
        return CoreServiceLocator.getInstabugSharedPreferences(context, INSTABUG_CHAT_SHARED_PREF_NAME);
    }

    // ====== perSession APIs ====== //

    @Nullable
    public static Runnable getNewMessageRunnable() {
        return PerSessionSettings.getInstance().getNewMessageRunnable();
    }

    public static void setNewMessageRunnable(Runnable newMessageRunnable) {
        PerSessionSettings.getInstance().setNewMessageRunnable(newMessageRunnable);
    }

    @Nullable
    public static String getHangingChatId() {
        return PerSessionSettings.getInstance().getHangingChatId();
    }

    public static void setHangingChatId(String hangingConversationId) {
        PerSessionSettings.getInstance().setHangingChatId(hangingConversationId);
    }

    @Nullable
    public static String getHangingMessageId() {
        return PerSessionSettings.getInstance().getHangingMessageId();
    }

    public static void setHangingMessageId(String hangingMessageId) {
        PerSessionSettings.getInstance().setHangingMessageId(hangingMessageId);
    }

    public static AttachmentTypesState getAttachmentTypesState() {
        return PerSessionSettings.getInstance().getAttachmentTypesState();
    }

    public static void setAttachmentsTypesParams(AttachmentTypesState attachmentsTypesParams) {
        PerSessionSettings.getInstance().setAttachmentsTypesParams(attachmentsTypesParams);
    }

    public static boolean isAttachmentsTypesEnabled() {
        AttachmentTypesState attachmentTypesState = getAttachmentTypesState();
        return attachmentTypesState.isScreenshotEnabled()
                || attachmentTypesState.isImageFromGalleryEnabled()
                || attachmentTypesState.isScreenRecordingEnabled();
    }

    public void setChatsState(Feature.State state) {
        PerSessionSettings.getInstance().setChatsState(state);
    }

    public boolean isChatsStateEnabled() {
        return PerSessionSettings.getInstance().isChatsStateEnabled();
    }

    public void setRepliesState(Feature.State state) {
        PerSessionSettings.getInstance().setRepliesState(state);
    }

    public boolean isRepliesStateEnabled() {
        return PerSessionSettings.getInstance().isRepliesStateEnabled();
    }

    public static boolean shouldSkipImageAttachmentAnnotation() {
        return PerSessionSettings.getInstance().shouldSkipImageAttachmentAnnotation();
    }

    public static void skipImageAttachmentAnnotation(boolean shouldSkipImageAttachmentAnnotation) {
        PerSessionSettings.getInstance().skipImageAttachmentAnnotation
                (shouldSkipImageAttachmentAnnotation);
    }

    @Nullable
    public static OnSdkDismissCallback getOnSdkDismissCallback() {
        return PerSessionSettings.getInstance().getOnSdkDismissCallback();
    }

    public static void setOnSdkDismissCallback(OnSdkDismissCallback onSdkDismissedCallback) {
        PerSessionSettings.getInstance().setOnSdkDismissCallback(onSdkDismissedCallback);
    }

    public static void setPushNotificationChannelId(String pushNotificationChannelId) {
        PerSessionSettings.getInstance().setPushNotificationChannelId(pushNotificationChannelId);
    }

    @Nullable
    public static String getPushNotificationChannelId() {
        return PerSessionSettings.getInstance().getPushNotificationChannelId();
    }

    // ====== PersistableSettings APIs ====== //

    @SuppressLint("NULL_DEREFERENCE")
    public static long getLastChatTime() {
        return PersistableSettings.getInstance().getLastChatTime();
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static void setLastChatTime(long time) {
        PersistableSettings.getInstance().setLastChatTime(time);
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static long getTTL() {
        return PersistableSettings.getInstance().getTTL();
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static void setTTL(long ttl) {
        PersistableSettings.getInstance().setTTL(ttl);
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static boolean isNotificationEnable() {
        return PersistableSettings.getInstance().isNotificationEnable();
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static void enableNotification(boolean isNotificationEnable) {
        PersistableSettings.getInstance().enableNotification(isNotificationEnable);
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static boolean isSystemNotificationSoundEnabled() {
        return PersistableSettings.getInstance().isSystemNotificationSoundEnabled();
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static void enableSystemNotificationSound(boolean isNotificationSoundEnabled) {
        PersistableSettings.getInstance().enableSystemNotificationSound(isNotificationSoundEnabled);
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static boolean isInAppNotificationSoundEnabled() {
        return PersistableSettings.getInstance().isInAppNotificationSoundEnabled();
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static void enableInAppNotificationSound(boolean isNotificationSoundEnabled) {
        PersistableSettings.getInstance().enableInAppNotificationSound(isNotificationSoundEnabled);
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static boolean isConversationSoundEnable() {
        return PersistableSettings.getInstance().isConversationSoundEnable();
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static void enableConversationSound(boolean isConversationSoundEnable) {
        PersistableSettings.getInstance().enableConversationSound(isConversationSoundEnable);
    }

    @SuppressLint("NULL_DEREFERENCE")
    @DrawableRes
    public static int getNotificationIcon() {
        return PersistableSettings.getInstance().getNotificationIcon();
    }

    @SuppressLint("NULL_DEREFERENCE")
    public static void setNotificationIcon(@DrawableRes int notificationIcon) {
        PersistableSettings.getInstance().setNotificationIcon(notificationIcon);
    }

    public static void release() {
        PerSessionSettings.release();
        PersistableSettings.release();
    }
}
