package com.instabug.bug.internal.video

import android.os.Build
import androidx.annotation.RequiresApi
import androidx.annotation.Size

object BugsVideoUtils {
        @Size(2)
        @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
        @JvmStatic
        fun getDimensInBounded(
            actualWidth: Double, actualHeight: Double,
            maxSupportedWidth: Double, maxSupportedHeight: Double
        ): DoubleArray? {
            var actualWidth = actualWidth
            var actualHeight = actualHeight
            var scaleDownFactor =
                if (actualWidth > actualHeight) actualWidth / actualHeight else actualHeight / actualWidth
            scaleDownFactor = Math.round(scaleDownFactor).toDouble()
            while (maxSupportedWidth < actualWidth || maxSupportedHeight < actualHeight) {
                actualWidth = actualWidth / scaleDownFactor
                actualHeight = actualHeight / scaleDownFactor
            }
            return doubleArrayOf(actualWidth, actualHeight)
        }
    }
