package com.instabug.bug.view.reporting.feedback;

import com.instabug.bug.extendedbugreport.ExtendedBugReport;
import com.instabug.bug.settings.BugSettings;
import com.instabug.bug.userConsent.UserConsentRepository;
import com.instabug.bug.userConsent.UserConsentsManager;
import com.instabug.bug.view.reporting.BaseReportingPresenter;
import com.instabug.bug.view.reporting.IBaseReportingView;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.util.PlaceHolderUtils;

import static com.instabug.bug.Constants.ReportType;

import androidx.annotation.NonNull;


/**
 * A presenter responsible for bug reporting experience, extend same shared reporting experience
 * among bug,feedback and chats
 * <H1>
 * FUNCTIONS
 * </H1>
 * <p>
 * 1- bug report type.
 * 2- hint message.
 * </P>
 *
 * <H1>
 * DEPENDENCIES
 * </H1>
 * <p>
 * 1- PlaceholderUtils {@link PlaceHolderUtils}
 * </P>
 */
public class FeedbackPresenter extends BaseReportingPresenter {
    public FeedbackPresenter(
            IBaseReportingView.View view,
            @NonNull UserConsentsManager userConsentsManager
    ) {
        super(view, userConsentsManager);
    }

    @Override
    @ReportType
    protected String getReportType() {
        return ReportType.FEEDBACK;
    }

    @Override
    public String getMessageHint() {
        String defaultMessage = "";
        if (view != null) {
            IBaseReportingView.View view = this.view.get();
            if (view != null) {
                defaultMessage = view.provideDefaultHintMessage();
            }
        }
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.COMMENT_FIELD_HINT_FOR_FEEDBACK,
                defaultMessage);
    }

    @Override
    public String getTitle() {
        String defaultTitle = "";
        if (view != null) {
            IBaseReportingView.View view = this.view.get();
            if (view != null) {
                defaultTitle = view.provideDefaultTitle();
            }
        }
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.REPORT_FEEDBACK,
                defaultTitle);

    }

    @Override
    public boolean hasExtendedReport() {
        return !BugSettings.getInstance().getExtraReportFields().isEmpty()
                || BugSettings.getInstance().getExtendedBugReportState()
                != ExtendedBugReport.State.DISABLED;
    }
}


