package com.instabug.bug.view.reporting.feedback;

import android.os.Bundle;

import com.instabug.bug.Constants;
import com.instabug.bug.R;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.view.reporting.BaseReportingFragment;
import com.instabug.bug.view.reporting.IBaseReportingView;

import androidx.annotation.Nullable;

public class FeedbackFragment extends BaseReportingFragment {

    @Nullable
    static public final String TAG = FeedbackFragment.class.getCanonicalName();

    public static FeedbackFragment newInstance(@Nullable String bugMessage) {
        FeedbackFragment fragment = new FeedbackFragment();
        Bundle args = new Bundle();
        args.putString(Constants.EXTRA_REPORTING_MESSAGE, bugMessage);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    @Nullable
    protected IBaseReportingView.Presenter createPresenter() {
        return ServiceLocator.getReportingPresenter(this);
    }

    @Override
    public String provideDefaultHintMessage() {
        return getLocalizedString(R.string.IBGSuggestImprovementHint);
    }

    @Override
    public String provideDefaultTitle() {
        return getLocalizedString(R.string.instabug_str_feedback_header);
    }

    @Override
    protected int getSendButtonContentDescriptionTitle() {
        return R.string.ibg_suggestion_send_content_description;
    }

    @Override
    protected int getCloseButtonContentDescription() {
        return R.string.ibg_core_ic_close_suggest_improvement_content_description;
    }

}
