package com.instabug.bug.view.reporting.bugreporting;

import android.os.Bundle;

import com.instabug.bug.Constants;
import com.instabug.bug.R;
import com.instabug.bug.di.ServiceLocator;
import com.instabug.bug.view.reporting.BaseReportingFragment;
import com.instabug.bug.view.reporting.IBaseReportingView;

import androidx.annotation.Nullable;

public class BugReportingFragment extends BaseReportingFragment {

    public static final String TAG = BugReportingFragment.class.getSimpleName();

    public static BugReportingFragment newInstance(@Nullable String bugMessage) {
        BugReportingFragment fragment = new BugReportingFragment();
        Bundle args = new Bundle();
        args.putString(Constants.EXTRA_REPORTING_MESSAGE, bugMessage);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    @Nullable
    protected IBaseReportingView.Presenter createPresenter() {
        return ServiceLocator.getReportingPresenter(this);
    }

    @Override
    public String provideDefaultHintMessage() {
        return getLocalizedString(R.string.IBGReportBugHint);
    }

    @Override
    public String provideDefaultTitle() {
        return getLocalizedString(R.string.IBGPromptOptionsReportBug);
    }

    @Override
    protected int getSendButtonContentDescriptionTitle() {
        return R.string.ibg_report_send_content_description;
    }

    @Override
    protected int getCloseButtonContentDescription() {
        return R.string.ibg_core_ic_close_bug_report_content_description;
    }

}
