package com.instabug.bug.view.reporting

import com.instabug.bug.userConsent.UserConsentRepository
import com.instabug.bug.userConsent.UserConsentsManager
import com.instabug.bug.view.reporting.askquestion.AskQuestionFragment
import com.instabug.bug.view.reporting.askquestion.AskQuestionPresenter
import com.instabug.bug.view.reporting.bugreporting.BugReportingFragment
import com.instabug.bug.view.reporting.bugreporting.BugReportingPresenter
import com.instabug.bug.view.reporting.feedback.FeedbackFragment
import com.instabug.bug.view.reporting.feedback.FeedbackPresenter
import com.instabug.bug.view.reporting.frustratingexperience.FrustratingExperienceFragment
import com.instabug.bug.view.reporting.frustratingexperience.FrustratingExperiencePresenter

interface ReportingPresenterFactory {
    fun create(view: IBaseReportingView.View): BaseReportingPresenter?
}

class ReportingPresenterFactoryImpl(private val manager: UserConsentsManager) : ReportingPresenterFactory {
    override fun create(view: IBaseReportingView.View) = when (view) {
        is AskQuestionFragment -> AskQuestionPresenter(view, manager)
        is BugReportingFragment -> BugReportingPresenter(view, manager)
        is FeedbackFragment -> FeedbackPresenter(view, manager)
        is FrustratingExperienceFragment -> FrustratingExperiencePresenter(view, manager)
        else -> null
    }
}