package com.instabug.bug.view.actionList;

import java.io.Serializable;

import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;

/**
 * Created by tarek on 10/18/16.
 */
public class ActionItem implements Serializable {
    private static final long serialVersionUID = 1905162041950251407L;

    private String label;
    private String description;
    private int icon;
    private transient Runnable action;

    public ActionItem(String label, String description, @DrawableRes int icon, @NonNull Runnable action) {
        this.label = label;
        this.action = action;
        this.icon = icon;
        this.description = description;
    }

    @NonNull public Runnable getAction() {
        return action;
    }

    public String getLabel() {
        return label;
    }

    public int getIcon() {
        return icon;
    }

    public boolean hasIcon(){
        return icon > 0;
    }

    public String getDescription() {
        return description;
    }
}
