package com.instabug.bug.view;

import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPORT_SUCCESSFULLY_SENT;
import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.SUCCESS_DIALOG_HEADER;
import static com.instabug.library.util.ThemeApplier.applyPrimaryTextStyle;
import static com.instabug.library.util.ThemeApplier.applySecondaryTextStyle;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;

import com.instabug.bug.Constants;
import com.instabug.bug.R;
import com.instabug.bug.utils.BugReportingThemeResolver;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugAppData;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.StatusBarUtils;
import com.instabug.library.util.ThemeApplier;
import com.instabug.library.util.UiUtils;

/**
 * Created by mzelzoghbi on 4/12/18.
 */
public class InstabugThanksActivity extends AppCompatActivity implements _InstabugActivity {

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        StatusBarUtils.setStatusBar(this);

        LocaleUtils.setLocale(this, InstabugCore.getLocale(this));
        super.onCreate(savedInstanceState);

        if (InstabugCore.isFullScreen()) {
            UiUtils.showInFullscreen(getWindow());
        }
        setTheme(BugReportingThemeResolver.resolveTheme(InstabugCore.getTheme()));

        setContentView(R.layout.ibg_bug_lyt_thanks);
        initViews();
    }

    private void initViews() {
        String successfullySentMsg = PlaceHolderUtils
                .getPlaceHolder(REPORT_SUCCESSFULLY_SENT, getSuccessNote());

        TextView successNoteTextView = findViewById(R.id.instabug_txt_success_note);
        if (successNoteTextView != null) {
            successNoteTextView.setText(successfullySentMsg);
        }

        TextView titleTextView = findViewById(com.instabug.library.R.id
                .instabug_fragment_title);
        if (titleTextView != null) {
            titleTextView.setText(PlaceHolderUtils.getPlaceHolder(SUCCESS_DIALOG_HEADER,
                    LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(this),
                            R.string.instabug_str_thank_you, this)));
            if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                titleTextView.setTextColor(InstabugCore.getPrimaryColor());
            } else {
                titleTextView.setTextColor(ContextCompat.getColor(this, android.R.color.white));
            }
        }

        ImageView brandingImage = findViewById(R.id.instabug_img_thanks);

        if (brandingImage != null) {
            brandingImage.setColorFilter(InstabugCore.getPrimaryColor());
            Drawable drawable = ContextCompat.getDrawable(this, R.drawable.ibg_bug_shape_thanks_background);
            if (drawable != null) {
                brandingImage.setBackgroundDrawable(Colorizer.getPrimaryColorTintedDrawable(drawable));
            }
        }

        View rootView = findViewById(R.id.instabug_success_dialog_container);
        handlePoweredByFooter(rootView);
        rootView.setOnClickListener(view -> {
            setResult(RESULT_OK);
            finish();
            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
        });

        applyTheme(findViewById(R.id.ib_success_layout), titleTextView, successNoteTextView);
    }

    @VisibleForTesting
    void applyTheme(@Nullable View container, @Nullable TextView titleTv, @Nullable TextView successNoteTv) {
        IBGTheme theme = SettingsManager.getInstance().getIBGTheme();
        if(theme != null) {

            if(container != null && theme.getBackgroundColor() != ThemeApplier.DEFAULT_COLOR) {
                container.setBackgroundColor(theme.getBackgroundColor());
            }

            applyPrimaryTextStyle(titleTv, theme);
            applySecondaryTextStyle(successNoteTv, theme);
        }
    }

    @Override
    public void onStart() {
        super.onStart();

        overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);

        if (AccessibilityUtils.isTalkbackEnabled() && Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            // 1. Build the event
            AccessibilityEvent event = AccessibilityEvent.obtain();
            event.setEventType(AccessibilityEvent.TYPE_ANNOUNCEMENT);
            event.setClassName(this.getClass().getName());
            event.setPackageName(this.getPackageName());

            // Your feedback has been sent
            event.getText().add(LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(this), R.string.ibg_bug_report_thanks_title_content_description, this));
            // Thank you
            TextView titleTextView = findViewById(R.id.instabug_fragment_title);
            if (titleTextView != null) {
                event.getText().add(titleTextView.getText());
            }

            // Powered by Instabug
            TextView pbiTextView = findViewById(R.id.text_view_pb);
            if (pbiTextView != null) {
                event.getText().add(pbiTextView.getText());
            }

            // 2. Send the event to the system
            AccessibilityManager manager = (AccessibilityManager) getSystemService(Context.ACCESSIBILITY_SERVICE);
            manager.sendAccessibilityEvent(event);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();

        new Handler(getMainLooper()).postDelayed(() -> {
            setResult(RESULT_OK);
            finish();
            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
        }, 4000);
    }

    @VisibleForTesting
    void handlePoweredByFooter(View view) {
        InstabugCore.handlePbiFooter(view);
    }

    @VisibleForTesting
    String getSuccessNote() {
        String appName = new InstabugAppData(this.getApplicationContext()).getAppName();
        if (appName == null) {
            InstabugSDKLogger.w(Constants.LOG_TAG, "It seems app:name isn't defined in your manifest. Using a " +
                    "generic name instead");
        }
        return LocaleUtils.getLocaleStringResource(
                InstabugCore.getLocale(this),
                R.string.instabug_str_success_note,
                this,
                appName == null ? "App" : appName);
    }
}
