package com.instabug.common.photopicker

import android.content.Intent
import android.net.Uri
import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.result.ActivityResultLauncher
import androidx.activity.result.PickVisualMediaRequest
import androidx.activity.result.contract.ActivityResultContracts.PickVisualMedia
import androidx.activity.result.contract.ActivityResultContracts.PickVisualMedia.ImageAndVideo
import com.instabug.library._InstabugActivity
import com.instabug.library.util.StatusBarUtils

private const val TAKING_PERSISTABLE_PERMISSION_ERROR_MESSAGE =
    "Something Went wrong while taking persistable URI Permission"

class PhotoPickerActivity : ComponentActivity(), _InstabugActivity {
    private lateinit var pickMedia: ActivityResultLauncher<PickVisualMediaRequest>

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        StatusBarUtils.setStatusBarForDialog(this)
        pickMedia = initPicker()
        pickMedia.launch(PickVisualMediaRequest(ImageAndVideo))
    }

    private fun initPicker() = registerForActivityResult(PickVisualMedia(), ::onUriReady)

    private fun onUriReady(uri: Uri?) {
        setResult(RESULT_OK, Intent().setData(uri))
        finish()
    }
}
