package com.instabug.chat;

import android.os.Bundle;

import com.instabug.chat.cache.ChatsCacheManager;
import com.instabug.chat.notification.NotificationManager;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.library.Feature;
import com.instabug.library.IBGFeature;
import com.instabug.library.core.InstabugCore;
import com.instabug.bug.invocation.InvocationManager;

import java.util.Map;

public class RepliesWrapper {

    public static void show() {
        if (isReadyToRun() && ChatsCacheManager.getValidChats().size() > 0) {
            ChatsDelegate.showChats();
        }
    }

    public static boolean hasChats() {
        return ChatsCacheManager.getValidChats().size() > 0;
    }

    public static void setRepliesState(Feature.State state) {
        InstabugCore.setRepliesState(state);
        InstabugCore.setPushNotificationState(state);
    }

    public static void setNewMessageHandler(Runnable runnable) {
        if (isReadyToRun())
            ChatsDelegate.setNewMessageHandler(runnable);
    }

    public static void enableNotification(boolean enabled) {
        if (isReadyToRun())
            ChatsDelegate.enableNotification(enabled);
    }

    public static int getUnreadMessagesCount() {
        return ChatsDelegate.getUnreadMessagesCount();
    }

    public static void setPushNotificationRegistrationToken(String token) {
        if (isReadyToRun())
            ChatsDelegate.setPushNotificationRegistrationToken(token);
    }

    public static void showNotification(Bundle data) {
        if (isMessagingServiceAvailable())
            ChatsDelegate.showNotification(data);
    }

    public static void showNotification(Map<String, String> data) {
        if (isMessagingServiceAvailable())
            ChatsDelegate.showNotification(data);
    }

    public static void enableInAppNotificationSound(boolean enabled) {
        if (isReadyToRun())
            ChatsDelegate.enableInAppNotificationSound(enabled);
    }

    public static void setNotificationIcon(int notificationIcon) {
        if (isReadyToRun())
            ChatSettings.setNotificationIcon(notificationIcon);
    }

    public static boolean isInstabugNotification(Bundle data) {
        return NotificationManager.getInstance().isInstabugNotification(data);
    }

    public static boolean isInstabugNotification(Map<String, String> data) {
        return NotificationManager.getInstance().isInstabugNotification(data);
    }

    public static void enableSystemNotificationSound(boolean enable) {
        if (isReadyToRun())
            ChatSettings.enableSystemNotificationSound(enable);
    }

    public static void setPushNotificationChannelId(String pushNotificationChannelId) {
        if (isReadyToRun())
            ChatSettings.setPushNotificationChannelId(pushNotificationChannelId);
    }

    public static void enableConversationSound(boolean shouldPlaySounds) {
        if (isReadyToRun())
            ChatSettings.enableConversationSound(shouldPlaySounds);
    }


    private static boolean isReadyToRun() {
        return InstabugCore.isFeatureEnabled(IBGFeature.REPLIES)
                && !isInForegroundWithNoSessionRunning();
    }

    public static void setState(Feature.State state) {
        RepliesWrapper.setRepliesState(state);
        InvocationManager.getInstance().notifyInvocationOptionChanged();
    }

    public static boolean isMessagingServiceAvailable() {
        return InstabugCore.isFeatureEnabled(IBGFeature.IN_APP_MESSAGING)
                && InstabugCore.isFeatureEnabled(IBGFeature.REPLIES);
    }

    /**
     * Determine if the app in the foreground and no session is running (This is usually could
     * * happened if the manual session controller feature is enabled and the user didn't stated a session).
     */
    private static boolean isInForegroundWithNoSessionRunning() {
        return InstabugCore.isAppOnForeground() && InstabugCore.getRunningSession() == null;
    }
}
