package com.instabug.bug.view.visualusersteps.visitedscreens;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.instabug.bug.R;
import com.instabug.bug.model.VisitedScreen;
import com.instabug.library.model.IBGTheme;

import java.util.ArrayList;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;

/**
 Created by Barakat on 05/05/2019
 */
public class VisualUserStepsListAdapter extends RecyclerView.Adapter<VisualUserStepItemViewHolder> {

    private VisualUserStepsListContract.View callback;
    private ArrayList<VisitedScreen> data = new ArrayList<VisitedScreen>();
    @Nullable
    private IBGTheme theme;

    public VisualUserStepsListAdapter(VisualUserStepsListContract.View callback, @Nullable IBGTheme theme) {
        this.callback = callback;
        this.theme = theme;
    }

    public VisitedScreen getItem(int position) {
        return data.get(position);
    }

    @NonNull
    @Override
    public VisualUserStepItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from(viewGroup.getContext())
                .inflate(R.layout.ibg_bug_repro_steps_item, viewGroup, false);
        return new VisualUserStepItemViewHolder(view, callback);
    }

    @Override
    public void onBindViewHolder(@NonNull final VisualUserStepItemViewHolder viewHolder, int i) {
        final VisitedScreen visitedScreen = getItem(i);
        viewHolder.bind(visitedScreen, theme);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return data.size();
    }

    void setData(ArrayList<VisitedScreen> data) {
        final VisitedScreensDiffUtils diffCallback = new VisitedScreensDiffUtils(this.data, data);
        final DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff(diffCallback, true);
        this.data.clear();
        this.data.addAll(data);
        diffResult.dispatchUpdatesTo(this);
    }
}
