package com.instabug.bug.reportingpromptitems;

import static com.instabug.library.util.LocaleUtils.getLocaleStringResource;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.bug.Constants;
import com.instabug.bug.Constants.ReportType;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.R;
import com.instabug.bug.ReportingActivityLauncher;
import com.instabug.bug.model.ReportCategory;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.invocation.InvocationMode;
import com.instabug.bug.invocation.invocationdialog.InstabugDialogActivity;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PlaceHolderUtils;

import java.util.ArrayList;

public class FeedbackPromptItem extends BaseReportingPromptItem {

    @Override
    public PluginPromptOption getItemOption(final Context context) {

        PluginPromptOption promptOption = new PluginPromptOption();
        promptOption.setOrder(Constants.PromptItemOrder.ORDER_FEEDBACK_REPORT_OPTION);
        promptOption.setInvocationMode(InvocationMode.NEW_FEEDBACK);
        promptOption.setPromptOptionIdentifier(PluginPromptOption.PromptOptionIdentifier.FEEDBACK);
        promptOption.setIcon(R.drawable.ibg_core_ic_suggest_improvment);
        promptOption.setTitle(getReportTitle(context));
        promptOption.setDescription(getReportDescription(context));
        promptOption.setOnInvocationListener(new PluginPromptOption.OnInvocationListener() {
            @Override
            public void onInvoke(@Nullable Uri initialScreenshotUri, String... reportCategories) {
                invoke(context, initialScreenshotUri, reportCategories);
            }
        });
        promptOption.setInitialScreenshotRequired(true);
        promptOption.setSubOptions(getSubOptions(ReportType.FEEDBACK));
        return promptOption;
    }


    @Override
    void handleNewReport(Context context) {

    }


    @NonNull
    @VisibleForTesting
    @Override
    String getReportTitle(Context context) {
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.REPORT_FEEDBACK,
                getLocaleStringResource(InstabugCore.getLocale(context),
                        R.string.instabug_str_feedback_header, context));
    }

    @Override
    @SuppressLint("ERADICATE_RETURN_NOT_NULLABLE")
    String getReportDescription(Context context) {
        return PlaceHolderUtils.getPlaceHolder(
                InstabugCustomTextPlaceHolder.Key.REPORT_FEEDBACK_DESCRIPTION,
                getLocaleStringResource(InstabugCore.getLocale(context),
                        R.string.ib_bug_report_feedback_description, context));
    }

    protected void invoke(Context context, @Nullable Uri initialScreenshotUri, String... reportCategories) {
        callOnSdkInvoked();
        InstabugSDKLogger.v(Constants.LOG_TAG, "Handle invocation request new feedback");
        createReportWithInitialScreenshot(initialScreenshotUri);
        if (LiveBugManager.getInstance().getBug() != null) {
            LiveBugManager.getInstance().getBug().setCategories(new ArrayList<String>());
            LiveBugManager.getInstance().getBug()
                    .addCategory(Constants.MainReportCategory.FEEDBACK);
            for (String reportCategory : reportCategories) {
                LiveBugManager.getInstance().getBug()
                        .addCategory(reportCategory);
            }
        }
        startViewHierarchyInspection();
        // to close the dialog if opened
        Intent intent = InstabugDialogActivity.getIntent(context, null, null, null, true);
        context.startActivity(intent);
        handleNewFeedback(context);
    }


    private void handleNewFeedback(Context context) {
        context.startActivity(ReportingActivityLauncher.newFeedbackProcessIntent(context));
    }

    @Override
    protected PluginPromptOption getSubOption(ReportCategory reportCategory,
                                              @Nullable PluginPromptOption parent,
                                              @ReportType String reportType, int order) {
        PluginPromptOption subOption = super.getSubOption(reportCategory, parent, reportType, order);
        subOption.setInvocationMode(InvocationMode.NEW_FEEDBACK);
        subOption.setPromptOptionIdentifier(PluginPromptOption.PromptOptionIdentifier.FEEDBACK);
        return subOption;
    }
}
