package com.instabug.bug.cache.migrationpolicy;

import com.instabug.bug.Constants;
import com.instabug.bug.settings.BugSettings;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.storage.cache.dbv2.migration.MigrationInterruptedException;
import com.instabug.library.util.InstabugSDKLogger;

import androidx.annotation.NonNull;

public class SelfMigrationInterruptionsPolicy implements MigrationInterruptionPolicy {

    private final Exception withException;

    public SelfMigrationInterruptionsPolicy(Exception withException) {
        this.withException = withException;
    }

    @Override
    public void migrate() {
        BugSettings.getInstance().setDbEncryptionMigrationStatus(false);
        String message = "Failed to migrate bugs encryption state";
        InstabugSDKLogger.e(Constants.LOG_TAG, message, withException);
        IBGDiagnostics.reportNonFatal(
                new MigrationInterruptedException(withException.getMessage()),
                message);
    }

    @NonNull
    @Override
    public String toString() {
        return "SelfMigrationInterruptionsPolicy{" +
                "withException=" + withException.getMessage() +
                '}';
    }
}
