package com.instabug.chat.ui.chat;

import static com.instabug.library.InstabugCustomTextPlaceHolder.Key;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.fragment.app.FragmentManager;

import com.instabug.bug.R;
import com.instabug.chat.Constants;
import com.instabug.bug.settings.BugSettings;
import com.instabug.chat.settings.ChatSettings;
import com.instabug.library.FragmentVisibilityChangedListener;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugBaseFragment;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.video.MediaProjectionHelper;
import com.instabug.library.model.IBGTheme;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.ResourcesUtils;
import com.instabug.library.util.ThemeApplier;

/**
 * @author Hossam
 */
@SuppressLint("ERADICATE_FIELD_NOT_INITIALIZED")
public class AttachmentsBottomSheetFragment extends InstabugBaseFragment implements View
        .OnClickListener, FragmentVisibilityChangedListener {

    @Nullable
    private AppCompatImageView attachScreenshotIV;
    @Nullable
    private AppCompatImageView attachVideoIV;
    @Nullable
    private AppCompatImageView attachFromGalleryIV;

    public static final String TAG = "attachments_bottom_sheet_fragment";
    Callbacks callbacks;
    private Runnable action;

    public static AttachmentsBottomSheetFragment newInstance(Callbacks callbacks) {
        AttachmentsBottomSheetFragment fragment = new AttachmentsBottomSheetFragment();
        fragment.callbacks = callbacks;
        return fragment;
    }

    @SuppressLint("STARVATION")
    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        if (AccessibilityUtils.isTalkbackEnabled()) {
            // For some reason, sometimes, the "Select file from Gallery" was not focused when clicked.
            // Here is the solution
            LinearLayout attachFromGalleryContainer = view.findViewById(R.id.instabug_attach_gallery_image);
            if (attachFromGalleryContainer != null) {
                ViewCompat.setAccessibilityDelegate(attachFromGalleryContainer,
                        new AccessibilityDelegateCompat() {
                            @Override
                            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                                super.onInitializeAccessibilityNodeInfo(host, info);
                                info.setImportantForAccessibility(true);
                            }
                        });
            }
        }

        attachScreenshotIV = view.findViewById(R.id.instabug_attach_screenshot_image_view);
        attachVideoIV = view.findViewById(R.id.instabug_attach_video_image_view);
        attachFromGalleryIV = view.findViewById(R.id.instabug_attach_gallery_image_view);

        LinearLayout attachScreenshotContainer = view.findViewById(R.id.instabug_attach_screenshot);
        if (attachScreenshotContainer != null) {
            if (shouldShowExtraScreenshot())
                attachScreenshotContainer.setOnClickListener(this);
            else
                attachScreenshotContainer.setVisibility(View.GONE);
        }

        LinearLayout attachImageContainer = view.findViewById(R.id.instabug_attach_gallery_image);
        if (attachImageContainer != null) {
            if (ChatSettings.getAttachmentTypesState().isImageFromGalleryEnabled())
                attachImageContainer.setOnClickListener(this);
            else
                attachImageContainer.setVisibility(View.GONE);
        }

        LinearLayout attachVideoContainer = view.findViewById(R.id.instabug_attach_video);
        if (attachVideoContainer != null) {
            if (shouldShowScreenRecording()) {
                attachVideoContainer.setOnClickListener
                        (this);
            } else {
                attachVideoContainer.setVisibility(View.GONE);
            }
        }

        View dimContainer = view.findViewById(R.id.instabug_attachments_bottom_sheet_dim_view);
        if (dimContainer != null) {
            dimContainer.setOnClickListener(this);
        }
        addCustomPlaceHolders(view);
        animateBottomSheet(view);
        inflateViews();
        LinearLayout bottomSheet = view.findViewById(R.id.instabug_attachments_actions_bottom_sheet);
        ThemeApplier.setScreenBackground(bottomSheet, getIbgTheme());
    }

    @Nullable
    private static IBGTheme getIbgTheme() {
        return SettingsManager.getInstance().getIBGTheme();
    }

    private void inflateViews() {
        try {
            AppCompatImageView attachScreenshotIV = this.attachScreenshotIV;
            if (getContext() != null) {
                int themeColorRes = Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeDark ?
                        R.color.instabug_theme_tinting_color_dark : R.color.instabug_theme_tinting_color_light;

                int themeColor = getThemeColor(themeColorRes);

                if (attachScreenshotIV != null) {
                    attachScreenshotIV.setImageDrawable(
                            ResourcesUtils.getDrawable(R.drawable.ibg_chat_ic_capture_screenshot, getContext()));
                    attachScreenshotIV.setColorFilter(themeColor, android.graphics.PorterDuff.Mode.SRC_IN);
                }
                this.attachScreenshotIV = attachScreenshotIV;

                AppCompatImageView attachVideoIV = this.attachVideoIV;
                if (attachVideoIV != null) {
                    attachVideoIV.setImageDrawable(
                            ResourcesUtils.getDrawable(R.drawable.ibg_core_ic_record_video, getContext()));
                    attachVideoIV.setColorFilter(themeColor, android.graphics.PorterDuff.Mode.SRC_IN);
                }
                this.attachVideoIV = attachVideoIV;

                AppCompatImageView attachFromGalleryIV = this.attachFromGalleryIV;
                if (attachFromGalleryIV != null) {
                    attachFromGalleryIV.setImageDrawable(
                            ResourcesUtils.getVectorDrawable(R.drawable.ibg_core_ic_attach_gallery_media, getContext()));
                    attachFromGalleryIV.setColorFilter(themeColor, android.graphics.PorterDuff.Mode.SRC_IN);
                }
                this.attachFromGalleryIV = attachFromGalleryIV;

            }
        } catch (Exception ex) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Failed to inflate view with exception: " + ex.getMessage(), ex);
        }
    }

    private int getThemeColor(int themeColorRes) {
        IBGTheme localTheme = getIbgTheme();
        return localTheme != null && localTheme.getPrimaryColor() != ThemeApplier.DEFAULT_COLOR
                ? localTheme.getPrimaryColor()
                : ContextCompat.getColor(requireContext(), themeColorRes);
    }

    private void animateBottomSheet(View rootView) {
        final View bottomSheet = rootView.findViewById(R.id.instabug_attachments_actions_bottom_sheet);
        if (bottomSheet != null) {
            bottomSheet.setAlpha(0);
            action = () -> {
                int height = bottomSheet.getHeight();
                bottomSheet.setTranslationY(height);
                bottomSheet.setAlpha(1);
                bottomSheet.animate().setDuration(100).translationYBy(-height);
            };
            bottomSheet.post(action);
        }
    }

    @Override
    public void onDestroy() {
        action = null;
        super.onDestroy();
    }

    @Override
    protected void saveState(Bundle outState) {

    }

    @Override
    protected void restoreState(Bundle savedInstanceState) {

    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_fragment_attachments_bottom_sheet;
    }

    @Override
    protected String getTitle() {
        return getString(com.instabug.library.R.string.instabug_str_empty);
    }

    @Override
    protected void consumeNewInstanceSavedArguments() {

    }

    @Override
    public void onClick(View v) {
        int id = v.getId();

        if (id == R.id.instabug_attach_screenshot) {
            removeCurrentFragment();
            callbacks.attachScreenshot();

        } else if (id == R.id.instabug_attach_gallery_image) {
            removeCurrentFragment();
            callbacks.attachImageFromGallery();

        } else if (id == R.id.instabug_attach_video) {
            removeCurrentFragment();
            callbacks.attachVideo();

        } else if (id == R.id.instabug_attachments_bottom_sheet_dim_view) {
            removeCurrentFragment();

        }

    }

    /**
     * removeCurrentFragment from Stack
     * for dismissing the current fragment
     */
    private void removeCurrentFragment() {
        if (getActivity() != null) {
            getActivity().getSupportFragmentManager().beginTransaction()
                    .remove(this)
                    .commit();
            getActivity().getSupportFragmentManager().popBackStack(TAG, FragmentManager
                    .POP_BACK_STACK_INCLUSIVE);
        }
    }

    @Override
    public void onVisibilityChanged(boolean isVisible) {

    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    private void addCustomPlaceHolders(View view) {
        Context context = getContext();
        if (context != null) {
            TextView attachGalleryImageTv = ((TextView) view.findViewById(R.id.instabug_attach_gallery_image_text));
            if (attachGalleryImageTv != null) {
                attachGalleryImageTv.setText(PlaceHolderUtils.getPlaceHolder(Key.ADD_IMAGE_FROM_GALLERY, LocaleUtils.getLocaleStringResource
                        (InstabugCore.getLocale(context), com.instabug.library.R.string.instabug_str_pick_media_from_gallery, context)));
                applyPrimaryTextStyle(attachGalleryImageTv);
            }

            TextView attachScreenshotText = ((TextView) view.findViewById(R.id.instabug_attach_screenshot_text));
            if (attachScreenshotText != null) {
                attachScreenshotText.setText(PlaceHolderUtils.getPlaceHolder(Key.ADD_EXTRA_SCREENSHOT, LocaleUtils.getLocaleStringResource
                        (InstabugCore.getLocale(context), com
                                .instabug.library.R.string.instabug_str_take_screenshot, context)));
                applyPrimaryTextStyle(attachScreenshotText);
            }

            TextView attachVideoTv = ((TextView) view.findViewById(R.id.instabug_attach_video_text));
            if (attachVideoTv != null) {
                attachVideoTv.setText(PlaceHolderUtils.getPlaceHolder(Key.ADD_VIDEO, LocaleUtils.getLocaleStringResource
                        (InstabugCore.getLocale(context), com.instabug.library.R.string.instabug_str_record_video, context)));
                applyPrimaryTextStyle(attachVideoTv);
            }
        }
    }

    private static void applyPrimaryTextStyle(TextView textView) {
        ThemeApplier.applyPrimaryTextStyle(textView,getIbgTheme());
    }


    private boolean shouldShowScreenRecording() {
        Context context = getContext();
        if (context != null) {
            return ChatSettings.getAttachmentTypesState().isScreenRecordingEnabled() && MediaProjectionHelper.INSTANCE.isMediaProjectionServiceAvailable(context);
        } else {
            return false;
        }
    }


    public boolean shouldShowExtraScreenshot() {
        boolean isExtraScreenshotAllowed = BugSettings.getInstance().getAttachmentsTypesParams().isAllowTakeExtraScreenshot();
        boolean isExtraScreenshotAllowedByMediaProjection = isExtraScreenshotAllowed && SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled();

        Context context = getContext();

        if (isExtraScreenshotAllowedByMediaProjection) {
            return context != null && MediaProjectionHelper.INSTANCE.isMediaProjectionServiceAvailable(context);
        } else {
            return isExtraScreenshotAllowed;
        }
    }

    public interface Callbacks {

        void attachScreenshot();

        void attachImageFromGallery();

        void attachVideo();

    }

}