package com.instabug.chat.annotation.shape;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;

import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;

import com.instabug.chat.annotation.DirectionRectF;

/**
 * Created by Tarek360 on 11/24/16.
 */

public abstract class CroppedRectShape extends Shape {

    @Nullable
    protected Bitmap background;

    public CroppedRectShape(@ColorInt int color) {
        super(color, 0);
    }

    public abstract void drawCroppedRect(Canvas canvas, Bitmap croppedBitmap, float drawX,
                                         float drawY);

    @Override
    public void draw(Canvas canvas, DirectionRectF bounds, DirectionRectF lastBounds) {
        if (background != null) {
            float x = bounds.left;
            float y = bounds.top;
            float cropWidth = bounds.width();
            float cropHeight = bounds.height();

            float cropX;
            float cropY;

            if (x < 0) {
                cropWidth += x;
                cropX = 0;
            } else {
                cropX = x;
            }

            if (y < 0) {
                cropHeight += y;
                cropY = 0;
            } else {
                cropY = y;
            }

            if (cropX + cropWidth > background.getWidth()) {
                cropWidth = background.getWidth() - cropX;
            }

            if (cropY + cropHeight > background.getHeight()) {
                cropHeight = background.getHeight() - cropY;
            }

            if (cropWidth > 0 && cropHeight > 0) {

                Bitmap croppedBitmap =
                        Bitmap.createBitmap(background, (int) cropX, (int) cropY, (int) cropWidth,
                                (int) cropHeight);

                float drawX = bounds.left;
                float drawY = bounds.top;
                if (bounds.left < 0) {
                    drawX = bounds.right - croppedBitmap.getWidth();
                }

                if (bounds.top < 0) {
                    drawY = bounds.bottom - croppedBitmap.getHeight();
                }

                drawCroppedRect(canvas, croppedBitmap, drawX, drawY);
            }
        }
    }

    @Override
    public boolean isTouched(PointF touchedPoint, DirectionRectF bounds) {

        final int EXTRA_HIT_STROKE_WIDTH = 20;

        float hitStrokeWidth = getStrokeWidth() + EXTRA_HIT_STROKE_WIDTH;
        RectF dst = new RectF(bounds);
        dst.inset(-hitStrokeWidth, -hitStrokeWidth);
        return dst.contains((int) touchedPoint.x, (int) touchedPoint.y);
    }

    @Override
    public void translateBy(DirectionRectF newBounds, DirectionRectF bounds, int dx, int dy) {
        newBounds.left = bounds.left + dx;
        newBounds.top = bounds.top + dy;
        newBounds.right = bounds.right + dx;
        newBounds.bottom = bounds.bottom + dy;
    }
}
