package com.instabug.bug.view.reporting;

import static com.instabug.bug.Constants.EXTRA_BITMAP_URI;
import static com.instabug.bug.Constants.EXTRA_PROCESS;
import static com.instabug.bug.Constants.ReportingProcess.PROCESS_BUG;
import static com.instabug.bug.view.reporting.BaseReportingPresenter.SHOW_THANK_YOU_ACTIVITY;
import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPORT_DISCARD_DIALOG_BODY;
import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPORT_DISCARD_DIALOG_NEGATIVE_ACTION;
import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPORT_DISCARD_DIALOG_POSITIVE_ACTION;
import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPORT_DISCARD_DIALOG_TITLE;
import static com.instabug.library.InstabugCustomTextPlaceHolder.Key.REPRO_STEPS_LIST_HEADER;
import static com.instabug.library.util.DrawableUtils.getRotateDrawable;
import static com.instabug.library.util.ThemeApplier.applyTitleStyle;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

import com.instabug.bug.BugPlugin;
import com.instabug.bug.BugsCoreEventsHandler;
import com.instabug.bug.Constants;
import com.instabug.bug.LiveBugManager;
import com.instabug.bug.OnSdkDismissedCallback;
import com.instabug.bug.R;
import com.instabug.bug.utils.BugReportingThemeResolver;
import com.instabug.bug.view.BugReportingActivityCallback;
import com.instabug.bug.view.BugReportingContract;
import com.instabug.bug.view.annotation.BugAnnotationFragment;
import com.instabug.bug.view.disclaimer.Disclaimer;
import com.instabug.bug.view.disclaimer.DisclaimerFragment;
import com.instabug.bug.view.disclaimer.DisclaimerHelper;
import com.instabug.bug.view.reporting.feedback.FeedbackFragment;
import com.instabug.bug.view.visualusersteps.steppreview.VisualUserStepArgs;
import com.instabug.library.FragmentVisibilityChangedListener;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.ui.BaseToolbarActivity;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.model.Attachment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.ui.custom.InstabugAlertDialog;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.KeyboardUtils;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.OrientationUtils;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.StatusBarUtils;

import java.util.ArrayList;
import java.util.List;

public class ReportingContainerActivity extends BaseToolbarActivity<BaseReportingContainerPresenter>
        implements _InstabugActivity, BugReportingContract.View,
        View.OnClickListener,
        BugAnnotationFragment.Callbacks,
        FragmentManager.OnBackStackChangedListener,
        DisclaimerFragment.Callbacks,
        BaseReportingFragment.Callbacks,
        BugReportingActivityCallback {


    private boolean shouldAnimateCapturedScreen = true;
    @Nullable
    private AlertDialog confirmationDialog;

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        BaseReportingContainerPresenter presenter = new BaseReportingContainerPresenter(this);
        this.presenter = presenter;
        if (DisclaimerHelper.isDisclaimerUri(intent.getData())) {
            openDisclaimerFragment();
        }
        int process = intent.getIntExtra(EXTRA_PROCESS, PROCESS_BUG);
        presenter.handleBugProcess(process);
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);

        if (!InstabugCore.isFullScreen()) {
            StatusBarUtils.darkenStatusBarColor(this, InstabugCore.getPrimaryColor());
        }

        if (InstabugCore.getTheme() != null) {
            setTheme(BugReportingThemeResolver.resolveTheme(InstabugCore.getTheme()));
        }

        overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
        if (LiveBugManager.getInstance().getBug() == null) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Bug is null, closing reporting activity and back to launch the app");
            finishActivity();
            return;
        }

        getSupportFragmentManager().addOnBackStackChangedListener(this);

        BaseReportingContainerPresenter presenter = new BaseReportingContainerPresenter(this);
        int currentProcess = getIntent().getIntExtra(EXTRA_PROCESS, PROCESS_BUG);
        this.presenter = presenter;
        if (savedInstanceState == null) {
            presenter.handleBugProcess(currentProcess);
        }
        this.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
    }

    public void setToolbarNavigationContentDescription(@StringRes int navigationContentDescription) {
        if (toolbar != null) {
            toolbar.setNavigationContentDescription(navigationContentDescription);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        BugPlugin plugin = (BugPlugin) InstabugCore.getXPlugin(BugPlugin.class);
        if (plugin != null) {
            plugin.setState(Plugin.STATE_FOREGROUND);
        }
        InstabugSDKLogger.d(Constants.LOG_TAG, "Reporting activity started, SDK Invoking State Changed: " + true);
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (confirmationDialog != null && confirmationDialog.isShowing()) {
            confirmationDialog.dismiss();
        }
    }


    @Override
    public void onStop() {
        BugPlugin plugin = (BugPlugin) InstabugCore.getXPlugin(BugPlugin.class);
        if (plugin != null && plugin.getState() != Plugin.STATE_PROCESSING_ATTACHMENT) {
            plugin.setState(Plugin.STATE_BACKGROUND);
        }
        InstabugSDKLogger.d(Constants.LOG_TAG, "Reporting activity paused, SDK Invoking State Changed: " + false);
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        if (presenter != null) {
            presenter.onDestroy();
        }
        if (!LiveBugManager.getInstance().isInBackground()
                && LiveBugManager.getInstance().getDismissType() == OnSdkDismissedCallback.DismissType.ADD_ATTACHMENT) {
            LiveBugManager.getInstance().setDismissType(OnSdkDismissedCallback.DismissType.CANCEL);
        }
        OrientationUtils.unlockOrientation(this);
        super.onDestroy();

    }

    @Override
    protected void initContentViews() {
        if (toolbar != null) {
            if (LiveBugManager.getInstance().getBug() == null) {
                toolbar.setNavigationIcon(null);
            }
            if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                toolbar.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
            } else {
                toolbar.setBackgroundColor(ContextCompat.getColor(this, R.color.instabug_attachment_bar_color_dark));
            }
        }
    }

    @Override
    protected int getContentLayout() {
        return R.layout.ibg_bug_activity_bug_reporting;
    }

    @Override
    public void onClick(View view) {
        final List<Fragment> fragments = new ArrayList<>(getSupportFragmentManager().getFragments());
        // NOTE for some reason all fragments closed are considered nulls so here we're removing all nulls
        List<Fragment> list = new ArrayList<>();
        list.add(null);
        fragments.removeAll(list);
    }

    @Override
    public void onBackPressed() {
        if (getSupportFragmentManager().getBackStackEntryCount() >= 1) {
            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
            super.onBackPressed();
        } else {
            KeyboardUtils.hide(this);
            showConfirmationDialog();
        }
    }

    @Override
    public void finish() {
        super.finish();
        overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
    }

    @VisibleForTesting
    public void dismissReport() {
        if (getSupportFragmentManager().getBackStackEntryCount() < 1) {

            LiveBugManager.getInstance().setDismissType(OnSdkDismissedCallback.DismissType.CANCEL);

            InstabugSDKLogger.d(Constants.LOG_TAG, "Reporting bug canceled. Deleting attachments");

            Cache cache = CacheManager.getInstance().getCache(CacheManager.DEFAULT_IN_MEMORY_CACHE_KEY);
            if (cache != null) {
                cache.delete(BaseReportingPresenter.VIDEO_PATH);
            }

            BugsCoreEventsHandler.handleSDKDismissing();
            this.finish();
        }
        if ((InstabugStateProvider.getInstance().getState() == InstabugState.TAKING_SCREENSHOT_FOR_CHAT ||
                InstabugStateProvider.getInstance().getState() == InstabugState.IMPORTING_IMAGE_FROM_GALLERY_FOR_CHAT)
                && getSupportFragmentManager().findFragmentById(R.id.instabug_fragment_container) instanceof BugAnnotationFragment) {
            InstabugStateProvider.getInstance().setState(InstabugState.ENABLED);
        }

        notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
    }

    @Override
    public void onBackStackChanged() {
        notifyFragmentVisibilityChanged(true, R.id.instabug_fragment_container);

    }

    @Override
    public void startBugReporter() {
        if (LiveBugManager.getInstance().getBug() == null) {
            return;
        }
        LiveBugManager.getInstance().getBug().setType(Constants.ReportType.BUG);

        String initialScreenshot = LiveBugManager.getInstance().getBug().getInitialScreenshotPath();
        if (!LiveBugManager.getInstance().getBug().hasMainScreenshot()
                && initialScreenshot != null) {
            LiveBugManager.getInstance().getBug().addAttachment(Uri.parse(initialScreenshot),
                    Attachment.Type.MAIN_SCREENSHOT);
        }

        notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        ReportingNavigator.navigateToBugReportingFragment(getSupportFragmentManager(),
                LiveBugManager.getInstance().getBug().getMessage(), false);

        if (presenter != null) {
            presenter.handlePoweredByFooter();
        }
    }

    @Override
    public void startFeedbackSender() {
        if (LiveBugManager.getInstance().getBug() == null) {
            return;
        }
        LiveBugManager.getInstance().getBug().setType(Constants.ReportType.FEEDBACK);

        String initialScreenshot = LiveBugManager.getInstance().getBug().getInitialScreenshotPath();

        if (!LiveBugManager.getInstance().getBug().hasMainScreenshot()
                && initialScreenshot != null) {
            LiveBugManager.getInstance().getBug().addAttachment(Uri.parse(initialScreenshot),
                    Attachment.Type.MAIN_SCREENSHOT);
        }

        notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);

        ReportingNavigator.navigateToFeedbackReportingFragment(getSupportFragmentManager(),
                LiveBugManager.getInstance().getBug().getMessage(), false);
        if (presenter != null) {
            presenter.handlePoweredByFooter();
        }
    }

    @Override
    public void onImageEditingDone(@Nullable Bitmap newBitmap, Uri originalUri) {
        InstabugSDKLogger.d(Constants.LOG_TAG, "onImageEditingDone");
        if (newBitmap != null) {
            BitmapUtils.saveBitmap(newBitmap, originalUri, this, new BitmapUtils.OnSaveBitmapCallback() {
                @Override
                public void onSuccess(Uri absolutePath) {
                    LiveBugManager.getInstance().refreshAttachments(ReportingContainerActivity.this);
                }

                @Override
                public void onError(Throwable throwable) {

                }
            });
        }

        notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);

        popFragment();

        if (getSupportFragmentManager().findFragmentByTag(FeedbackFragment.TAG) == null) {
            if (presenter != null) {
                presenter.startNavigation();
            }
        }
    }


    @Override
    public void onImageEditingCancelled() {

    }

    @Override
    public void startWithHangingBug() {
        InstabugSDKLogger.d(Constants.LOG_TAG, "startWithHangingBug");
        if (LiveBugManager.getInstance().getBug() != null) {
            InstabugSDKLogger.d(Constants.LOG_TAG, "bug attachment size: "
                    + LiveBugManager.getInstance().getBug().getAttachments().size());
        }
        LiveBugManager.getInstance().setIsInBackground(false);
        if (getSupportFragmentManager().findFragmentByTag(FeedbackFragment.TAG) == null) {
            notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
            if (presenter != null) {
                presenter.startNavigation();
            }
        }
        LiveBugManager.getInstance().refreshAttachments(ReportingContainerActivity.this);

        if (presenter != null) {
            presenter.handlePoweredByFooter();
        }
    }

    @Override
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public void loadBitmapAnimation(final float pivotXValue, final float pivotYValue) {
        if ((getIntent().getParcelableExtra(EXTRA_BITMAP_URI)) != null
                && shouldAnimateCapturedScreen) {
            shouldAnimateCapturedScreen = false;
            // extra screenshot available
            // handle capture screen animation
            ViewGroup vg = (ViewGroup) (getWindow().getDecorView().getRootView());
            final ImageView iv = new ImageView(this);
            iv.setBackgroundColor(ContextCompat.getColor(this, android.R.color.white));
            vg.addView(iv, new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
            Uri screenshotUri = ((Uri) getIntent().getParcelableExtra(EXTRA_BITMAP_URI));
            if (screenshotUri != null && screenshotUri.getPath() != null) {
                BitmapUtils.loadBitmap(screenshotUri.getPath(), iv
                        , new BitmapWorkerTask.OnImageLoadedListener() {
                            @Override
                            public void onImageLoaded() {
                                ScaleAnimation fade_in = new ScaleAnimation(1f, 0f, 1f, 0f,
                                        Animation.RELATIVE_TO_SELF, pivotXValue, Animation.RELATIVE_TO_SELF, pivotYValue);
                                fade_in.setDuration(500);     // animation duration in milliseconds
                                fade_in.setFillAfter(false);
                                fade_in.setAnimationListener(new Animation.AnimationListener() {
                                    @Override
                                    public void onAnimationStart(Animation animation) {

                                    }

                                    @Override
                                    public void onAnimationEnd(Animation animation) {
                                        iv.setVisibility(View.GONE);
                                    }

                                    @Override
                                    public void onAnimationRepeat(Animation animation) {

                                    }
                                });
                                iv.startAnimation(fade_in);
                            }
                        });
                getIntent().putExtra(Constants.EXTRA_BITMAP_URI, (Parcelable) null);
            }
        }

    }

    private void notifyFragmentVisibilityChanged(boolean isVisible, int fragmentContainer) {
        if ((getSupportFragmentManager().findFragmentById(fragmentContainer) instanceof FragmentVisibilityChangedListener)) {
            ((FragmentVisibilityChangedListener) getSupportFragmentManager()
                    .findFragmentById(fragmentContainer)).onVisibilityChanged(isVisible);
        }
    }

    @Override
    public void handlePoweredByFooter() {
        View footerContainer = findViewById(R.id.instabug_pbi_container);
        InstabugCore.handlePbiFooter(footerContainer);
        int footerFgColor = AttrResolver.resolveAttributeColor(getViewContext(), R.attr.instabug_foreground_color);
        InstabugCore.setPbiFooterThemeColor(footerContainer, footerFgColor);
        int footerBgColor = AttrResolver.getColor(getViewContext(), R.attr.ibg_bug_color_bg_pbi);
        footerContainer.setBackgroundColor(footerBgColor);

        if (AccessibilityUtils.isTalkbackEnabled()) {
            ViewCompat.setImportantForAccessibility(findViewById(R.id.instabug_pbi_container), ViewCompat.IMPORTANT_FOR_ACCESSIBILITY_NO_HIDE_DESCENDANTS);
        }
    }

    @Override
    public void navigateToFeedback() {
        String message = LiveBugManager.getInstance().getBug() != null ?
                LiveBugManager.getInstance().getBug().getMessage() : null;
        ReportingNavigator.navigateToFeedbackReportingFragment(getSupportFragmentManager(), message, false);
    }

    @Override
    public void startAskQuestion() {
        notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        String message = LiveBugManager.getInstance().getBug() != null ?
                LiveBugManager.getInstance().getBug().getMessage() : null;
        ReportingNavigator.navigateToAskQuestion(getSupportFragmentManager(), message, false);
    }

    @Override
    public void startFrustratingExperience() {
        notifyFragmentVisibilityChanged(false, R.id.instabug_fragment_container);
        String message = LiveBugManager.getInstance().getBug() != null ?
                LiveBugManager.getInstance().getBug().getMessage() : null;
        ReportingNavigator.navigateToFrustratingExperience(getSupportFragmentManager(),message, false);
    }

    @Override
    public void navigateToBugReporting() {
        String message = LiveBugManager.getInstance().getBug() != null ?
                LiveBugManager.getInstance().getBug().getMessage() : null;
        ReportingNavigator.navigateToBugReportingFragment(getSupportFragmentManager(), message, false);
    }

    @Override
    public void onFeedbackFragmentDismissed() {
        Cache cache = CacheManager.getInstance().getCache(CacheManager.DEFAULT_IN_MEMORY_CACHE_KEY);
        if (cache != null) {
            cache.delete(BaseReportingPresenter.VIDEO_PATH);
        }
        finish();
    }

    @Override
    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == SHOW_THANK_YOU_ACTIVITY) {
            overridePendingTransition(android.R.anim.fade_in, android.R.anim.fade_out);
            finishActivity();
            return;
        }
        for (Fragment fragment : getSupportFragmentManager().getFragments()) {
            fragment.onActivityResult(requestCode, resultCode, data);
        }
    }


    private void popFragment() {
        if (!isFinishing() && !getSupportFragmentManager().isStateSaved())
            getSupportFragmentManager().popBackStackImmediate();
    }

    private void openDisclaimerFragment() {
        notifyFragmentVisibilityChanged(false, com.instabug.library.R.id.instabug_fragment_container);
        ReportingNavigator.navigateToDisclaimerFragment(getSupportFragmentManager(), true);
    }

    private void openDisclaimerDetailsFragment(Disclaimer disclaimer) {
        notifyFragmentVisibilityChanged(false, com.instabug.library.R.id.instabug_fragment_container);

        ReportingNavigator.navigateToDisclaimerDetailsFragment(getSupportFragmentManager(), disclaimer);
    }

    @Override
    public void openVisualUserStepsDisclaimerFragment() {
        notifyFragmentVisibilityChanged(false, com.instabug.library.R.id.instabug_fragment_container);

        ReportingNavigator.navigateToVisualUserStepListFragment(
                getSupportFragmentManager(), getReproStepsListTitle());

    }

    private String getReproStepsListTitle() {
        return PlaceHolderUtils.getPlaceHolder(this,
                REPRO_STEPS_LIST_HEADER,
                R.string.IBGReproStepsListTitle);
    }

    @Override
    public void openStepPreviewFragment(@NonNull VisualUserStepArgs args) {
        notifyFragmentVisibilityChanged(false, com.instabug.library.R.id.instabug_fragment_container);
        ReportingNavigator.navigateToVisualUserStepPreview(
                getSupportFragmentManager(), args);


    }

    @Override
    public void openDisclaimerDetails(Disclaimer disclaimer) {
        openDisclaimerDetailsFragment(disclaimer);
    }

    @Override
    public void setToolbarUpIconBack() {
        Toolbar toolbar = this.toolbar;
        if (toolbar != null) {
            if (LocaleUtils.isRTL(InstabugCore.getLocale(this))) {
                Drawable rotatedDrawable = ContextCompat.getDrawable(this, R.drawable.ibg_core_ic_back);
                if (rotatedDrawable != null) {
                    toolbar.setNavigationIcon(getRotateDrawable(rotatedDrawable, 180));
                }
            } else {
                toolbar.setNavigationIcon(R.drawable.ibg_core_ic_back);
            }
        }
        this.toolbar = toolbar;
    }

    @Override
    public void setToolbarTitle(String title) {
        setTitle(title);
        applyThemeToTitle();
    }

    private void applyThemeToTitle() {
        if (toolbar != null) {
            View title = toolbar.getChildAt(0);
            if (title instanceof TextView) {
                TextView titleTv = (TextView) title;

                applyTitleStyle(titleTv, SettingsManager.getInstance().getIBGTheme());
            }
        }
    }


    @Override
    public String getToolbarTitle() {
        return String.valueOf(getTitle());
    }

    @Override
    public void setToolbarUpIconClose() {
        if (toolbar != null) {
            toolbar.setNavigationIcon(R.drawable.ibg_core_ic_close);
        }
    }

    private void showConfirmationDialog() {
        confirmationDialog = new InstabugAlertDialog.Builder(this)
                .setTitle(getConfirmationDialogTitle())
                .setMessage(getConfirmationDialogMessage())
                .setPositiveButtonAccessibilityContentDescription(getConfirmationDialogPositiveAction())
                .setNegativeButtonAccessibilityContentDescription(getConfirmationDialogNegativeAction())
                .setPositiveButton(getConfirmationDialogPositiveAction(), (dialogInterface, i) -> {
                    dialogInterface.dismiss();
                    dismissReport();
                    confirmationDialog = null;
                })
                .setNegativeButton(getConfirmationDialogNegativeAction(), null)
                .show();
    }

    private String getConfirmationDialogTitle() {
        return PlaceHolderUtils.getPlaceHolder(this,
                REPORT_DISCARD_DIALOG_TITLE,
                R.string.instabug_str_bugreport_dismiss_warning_title);
    }

    private String getConfirmationDialogMessage() {
        return PlaceHolderUtils.getPlaceHolder(this,
                REPORT_DISCARD_DIALOG_BODY,
                R.string.instabug_str_bugreport_dismiss_warning_message);
    }

    private String getConfirmationDialogPositiveAction() {
        return PlaceHolderUtils.getPlaceHolder(this,
                REPORT_DISCARD_DIALOG_POSITIVE_ACTION,
                R.string.instabug_str_bugreport_dismiss_discard);
    }

    private String getConfirmationDialogNegativeAction() {
        return PlaceHolderUtils.getPlaceHolder(this,
                REPORT_DISCARD_DIALOG_NEGATIVE_ACTION,
                R.string.instabug_str_bugreport_dismiss_cancel);
    }

    private String getLocalizedString(@StringRes int resourceId) {
        return LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(ReportingContainerActivity.this), resourceId,
                ReportingContainerActivity.this);
    }
}
