package com.instabug.bug.invocation.util;

import androidx.annotation.Nullable;

import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class AtomicArray {

    @Nullable
    public static <T> T[] toArray(@Nullable AtomicReferenceArray<T> atomicReferenceArray, Class<T> clazz) {
        if (atomicReferenceArray == null) {
            return null;
        }
        T[] result = (T[]) Array.newInstance(clazz, atomicReferenceArray.length());
        for (int i = 0; i < atomicReferenceArray.length(); i++) {
            result[i] = atomicReferenceArray.get(i);
        }
        return result;
    }
}
