/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.bug.di.a;
import com.instabug.bug.j;
import com.instabug.bug.network.h;
import com.instabug.bug.utils.c;
import com.instabug.bug.view.actionList.service.b;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventSubscriber;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGCompositeDisposable;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tokenmapping.MappedTokenChangedEventBus;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.visualusersteps.ReproConfigurationsProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class BugPlugin
extends Plugin {
    @Nullable
    private IBGCompositeDisposable disposables;
    @Nullable
    @VisibleForTesting
    IBGDisposable mappedTokenChangedDisposable;

    private void subscribeOnCoreEvents() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            this.getOrCreateCompositeDisposables().add(this.subscribeToCoreEvents());
        }
    }

    @NonNull
    private IBGDisposable subscribeToCoreEvents() {
        return IBGCoreEventSubscriber.subscribe(iBGSdkCoreEvent -> {
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (weakReference != null) {
                com.instabug.bug.c.a((Context)weakReference.get(), iBGSdkCoreEvent);
            }
        });
    }

    private void subscribeOnMappedTokenChangedEvent() {
        if (this.mappedTokenChangedDisposable == null) {
            this.mappedTokenChangedDisposable = MappedTokenChangedEventBus.INSTANCE.subscribe(bl -> {
                b.a().f();
                b.a().start();
            });
        }
    }

    private void unsubscribeFromMappedTokenChangedEvents() {
        IBGDisposable iBGDisposable = this.mappedTokenChangedDisposable;
        if (iBGDisposable != null) {
            iBGDisposable.dispose();
            this.mappedTokenChangedDisposable = null;
        }
    }

    private void loadAndApplyCachedReproConfigurations() {
        SettingsManager settingsManager = SettingsManager.getInstance();
        if (settingsManager != null) {
            settingsManager = settingsManager.getReproConfigurations();
            WeakReference weakReference = ((Plugin)weakReference).contextWeakReference;
            if (settingsManager != null && weakReference != null) {
                com.instabug.bug.c.a((Context)weakReference.get(), (IBGSdkCoreEvent)new IBGSdkCoreEvent.ReproState(settingsManager.getModesMap()));
            }
        }
    }

    private void unSubscribeFromCoreEvents() {
        BugPlugin bugPlugin = bugPlugin.disposables;
        if (bugPlugin != null) {
            bugPlugin.dispose();
        }
    }

    private IBGCompositeDisposable getOrCreateCompositeDisposables() {
        IBGCompositeDisposable iBGCompositeDisposable = this.disposables;
        if (iBGCompositeDisposable == null) {
            IBGCompositeDisposable iBGCompositeDisposable2;
            iBGCompositeDisposable = iBGCompositeDisposable2;
            iBGCompositeDisposable2 = new IBGCompositeDisposable();
            this.disposables = iBGCompositeDisposable;
        }
        return iBGCompositeDisposable;
    }

    public void init(Context context) {
        Context context2 = context;
        a.e().a();
        a.g().evaluate((ReproConfigurationsProvider)a.e());
        a.h().addWatcher(4);
        c.c(context2);
        super.init(context2);
    }

    public void wake() {
        a.h().consentOnCleansing(4);
    }

    public void sleep() {
    }

    public void initDefaultPromptOptionAvailabilityState() {
        j.c();
    }

    public ArrayList<PluginPromptOption> getPromptOptions() {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return j.a((Context)this.contextWeakReference.get());
        }
        return new ArrayList<PluginPromptOption>();
    }

    @Nullable
    public ArrayList<PluginPromptOption> getPluginOptions(boolean bl) {
        WeakReference weakReference = this.contextWeakReference;
        if (weakReference != null && weakReference.get() != null) {
            return j.a(bl, (Context)this.contextWeakReference.get());
        }
        return null;
    }

    public boolean isFeatureEnabled() {
        return InstabugCore.isFeatureEnabled((String)"BUG_REPORTING");
    }

    public void stop() {
        BugPlugin bugPlugin = this;
        j.g();
        bugPlugin.unSubscribeFromCoreEvents();
        bugPlugin.unsubscribeFromMappedTokenChangedEvents();
    }

    public void start(Context context) {
        PoolProvider.postIOTaskWithCheck(() -> {
            BugPlugin bugPlugin = this;
            this.loadAndApplyCachedReproConfigurations();
            j.b(context);
            bugPlugin.subscribeOnCoreEvents();
            bugPlugin.subscribeOnMappedTokenChangedEvent();
            h.b().start();
        });
    }

    public long getLastActivityTime() {
        return com.instabug.bug.settings.b.h().i();
    }
}

