/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug.model;

import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import com.instabug.bug.w;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportCategory {
    private static final String TAG = "ReportCategory";
    private static final String KEY_LABEL = "name";
    private static final String KEY_SUBS = "subs";
    private static final String KEY_SLUG = "slug";
    private static final String CATEGORY_REPORT_A_PROBLEM = "report-a-problem";
    private static final String CATEGORY_SUGGEST_AN_IMPROVEMENT = "suggest-an-improvement";
    private static final String CATEGORY_ASK_A_QUESTION = "ask-a-question";
    private static final String KEY_DESCRIPTION = "description";
    @Nullable
    private String description;
    @Nullable
    private String label;
    private int icon;
    @Nullable
    private List<ReportCategory> subs;

    private ReportCategory() {
    }

    public static ReportCategory getInstance() {
        return new ReportCategory();
    }

    private static ReportCategory fromJsonObject(JSONObject jSONObject) {
        ArrayList<ReportCategory> arrayList;
        ReportCategory reportCategory;
        ReportCategory reportCategory2 = reportCategory;
        reportCategory = new ReportCategory();
        if (jSONObject.has(KEY_LABEL)) {
            reportCategory2.setLabel(jSONObject.getString(KEY_LABEL));
        }
        if (jSONObject.has(KEY_DESCRIPTION)) {
            reportCategory2.setDescription(jSONObject.getString(KEY_DESCRIPTION));
        }
        ArrayList<ReportCategory> arrayList2 = arrayList;
        arrayList = new ArrayList<ReportCategory>();
        if (jSONObject.has(KEY_SUBS)) {
            jSONObject = jSONObject.getJSONArray(KEY_SUBS);
            for (int i2 = 0; i2 < jSONObject.length(); ++i2) {
                arrayList2.add(ReportCategory.fromJsonObject(jSONObject.getJSONObject(i2)));
            }
        }
        ReportCategory reportCategory3 = reportCategory2;
        reportCategory3.setSubs(arrayList2);
        return reportCategory3;
    }

    private void setSubs(@Nullable List<ReportCategory> list) {
        this.subs = list;
    }

    @Nullable
    public static List<ReportCategory> getSubReportCategories(String list) {
        if ((list = ReportCategory.getRemoteSubReportCategories((String)((Object)list))) == null) {
            list = w.e().j();
        }
        return list;
    }

    @Nullable
    private static List<ReportCategory> getRemoteSubReportCategories(String list) {
        block21: {
            JSONArray jSONArray;
            block22: {
                block23: {
                    int n2;
                    block20: {
                        block18: {
                            block19: {
                                JSONArray jSONArray2;
                                String string2 = w.e().i();
                                if (string2 == null) break block21;
                                String string3 = list;
                                jSONArray = jSONArray2;
                                jSONArray2 = new JSONArray(string2);
                                n2 = -1;
                                int n3 = string3.hashCode();
                                if (n3 == -191501435) break block18;
                                if (n3 == 97908) break block19;
                                if (n3 != 1621082316) break block20;
                                if (((String)((Object)list)).equals("ask a question")) {
                                    n2 = 2;
                                }
                                break block20;
                            }
                            if (((String)((Object)list)).equals("bug")) {
                                n2 = 0;
                            }
                            break block20;
                        }
                        if (!((String)((Object)list)).equals("feedback")) break block20;
                        n2 = 1;
                    }
                    if (n2 == 0) break block22;
                    if (n2 == 1) break block23;
                    if (n2 != 2) break block21;
                    list = ReportCategory.getSubCategories(jSONArray, CATEGORY_ASK_A_QUESTION);
                    if (list == null) break block21;
                    if (list.size() > 0) {
                        return list;
                    }
                }
                list = ReportCategory.getSubCategories(jSONArray, CATEGORY_SUGGEST_AN_IMPROVEMENT);
                if (list == null) break block21;
                if (list.size() > 0) {
                    return list;
                }
            }
            list = ReportCategory.getSubCategories(jSONArray, CATEGORY_REPORT_A_PROBLEM);
            if (list == null) break block21;
            try {
                if (list.size() > 0) {
                    return list;
                }
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e((Object)TAG, (String)"error while getRemoteSubReportCategories", (Throwable)jSONException);
            }
        }
        return null;
    }

    @Nullable
    private static List<ReportCategory> getSubCategories(JSONArray jSONArray, String string2) {
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            if (!string2.equals(jSONArray.getJSONObject(i2).getString(KEY_SLUG))) continue;
            return ReportCategory.fromJsonObject(jSONArray.getJSONObject(i2)).getSubs();
        }
        return null;
    }

    public static boolean hasSubCategories(String object) {
        List<ReportCategory> list = ReportCategory.getRemoteSubReportCategories("bug");
        List<ReportCategory> list2 = ReportCategory.getRemoteSubReportCategories("feedback");
        List<ReportCategory> list3 = ReportCategory.getRemoteSubReportCategories("ask a question");
        boolean bl = false;
        if (list != null && !list.isEmpty()) {
            if (((String)object).equals("bug")) {
                return true;
            }
            bl = true;
        }
        if (list2 != null && !list2.isEmpty()) {
            if (((String)object).equals("feedback")) {
                return true;
            }
            bl = true;
        }
        if (list3 != null && !list3.isEmpty()) {
            if (((String)object).equals("ask a question")) {
                return true;
            }
            bl = true;
        }
        object = w.e().j();
        return !bl && object != null && object.size() > 0;
    }

    public ReportCategory withLabel(String string2) {
        this.label = string2;
        return this;
    }

    public ReportCategory withIcon(@DrawableRes int n2) {
        this.icon = n2;
        return this;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string2) {
        this.label = StringUtility.ellipsize((String)string2, (int)35);
    }

    public int getIcon() {
        return this.icon;
    }

    public void setIcon(@DrawableRes int n2) {
        this.icon = n2;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public List<ReportCategory> getSubs() {
        return this.subs;
    }

    public void setDescription(String string2) {
        this.description = StringUtility.ellipsize((String)string2, (int)75);
    }
}

