package com.instabug.apm.webview.webview_trace.model.event

import com.instabug.apm.model.EventTimeMetricCapture

class WebViewLoadDataWithUrlEvent : WebViewEvent, WebViewTraceInitiationEvent {

    override val traceId: Long
    override val shouldInitiateNewTrace = false

    constructor(
        traceId: Long,
        timeCapture: EventTimeMetricCapture,
        copyCount: Int = 0
    ) : super(
        id = WebViewEventId.LOAD_DATA_WITH_URL,
        timeCapture = timeCapture,
        isTermination = true,
        copyCount = copyCount,
    ) {
        this.traceId = traceId
    }

    constructor(
        from: WebViewLoadDataWithUrlEvent,
        isTerminationOverride: Boolean? = null
    ) : super(from, isTerminationOverride) {
        this.traceId = from.traceId
    }

    override fun copy(isTerminationOverride: Boolean?): WebViewLoadDataWithUrlEvent =
        WebViewLoadDataWithUrlEvent(this, isTerminationOverride)
}