package com.instabug.apm.screenloading.di

import android.os.Handler
import android.os.Looper
import com.instabug.apm.di.Provider
import com.instabug.apm.sanitization.Validator
import com.instabug.apm.screenloading.handler.CPScreenLoadingHandlerImpl
import com.instabug.apm.screenloading.handler.NativeScreenLoadingHandlerImpl
import com.instabug.apm.screenloading.repo.NativeScreenLoadingRepo
import com.instabug.library.factory.ParameterizedFactory

class NativeScreenLoadingFactoryProvider :
    Provider<ParameterizedFactory<NativeScreenLoadingHandlerImpl, NativeScreenLoadingRepo>> {
    override fun invoke(): ParameterizedFactory<NativeScreenLoadingHandlerImpl, NativeScreenLoadingRepo> =
        ScreenLoadingServiceLocator.createNativeScreenLoadingHandlerFactory()
}

class CPScreenLoadingHandlerProvider : Provider<CPScreenLoadingHandlerImpl> {
    override fun invoke(): CPScreenLoadingHandlerImpl =
        ScreenLoadingServiceLocator.createCpScreenLoadingHandler()
}

class MainThreadHandlerProvider : Provider<Handler> {
    override fun invoke(): Handler = Handler(Looper.getMainLooper())
}

class EndScreenLoadingConfigurationValidatorProvider : Provider<Validator<Unit>> {
    override fun invoke(): Validator<Unit> =
        ScreenLoadingServiceLocator.endScreenLoadingConfigurationValidator
}