package com.instabug.apm.appflow.validate

import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider
import com.instabug.apm.appflow.log.logFeatureBEDisabled
import com.instabug.apm.configuration.APMConfigurationProvider
import com.instabug.apm.logger.internal.Logger
import com.instabug.apm.sanitization.Validator

class AppFlowAttributeConfigurationValidator(
    apiName: String,
    apmConfigurations: APMConfigurationProvider,
    appFLowConfigurations: AppFlowConfigurationProvider,
    logger: Logger
): ConfigurationsValidator(
    apiName,
    apmConfigurations,
    appFLowConfigurations,
    logger
), Validator<Unit> {

    override fun isValid(item: Unit): Boolean {
        return super.isValid(item) && validateAttributeConfigurationsAndLogIfNot()
    }

    private fun validateAttributeConfigurationsAndLogIfNot() =
        appFLowConfigurations.attributesEnabled.also { isValid ->
            if (!isValid) {
                logger.logFeatureBEDisabled(apiName)
            }
        }
}