package com.instabug.apm.appflow.map

import android.database.Cursor
import com.instabug.apm.appflow.model.AppFlowCacheModel
import com.instabug.library.internal.storage.cache.db.contract.apm.ApmAppFlowEntry
import com.instabug.library.internal.storage.cache.db.contract.apm.ApmAppFlowTableAttributeEntry
import com.instabug.library.parse.Parser
import com.instabug.library.util.extenstions.getBoolean

class AppFlowCursorParser : Parser<Cursor?, List<AppFlowCacheModel>?> {

    override fun parse(source: Cursor?): List<AppFlowCacheModel>? =
        source?.takeIf { it.moveToFirst() }?.let { cursor ->
            ArrayList<AppFlowCacheModel>().also { modelList ->
                val idIndex = cursor.getColumnIndexOrThrow(ApmAppFlowEntry.COLUMN_ID)
                val nameIndex = cursor.getColumnIndexOrThrow(ApmAppFlowEntry.COLUMN_NAME)
                val startTimeStampIndex = cursor.getColumnIndexOrThrow(ApmAppFlowEntry.COLUMN_START_TIMESTAMP_MU)
                val startTimeIndex = cursor.getColumnIndexOrThrow(ApmAppFlowEntry.COLUMN_START_TIME_MU)
                val endTimeIndex = cursor.getColumnIndexOrThrow(ApmAppFlowEntry.COLUMN_END_TIME_MU)
                val endReasonIndex = cursor.getColumnIndexOrThrow(ApmAppFlowEntry.COLUMN_END_REASON)
                val backgroundIndex = cursor.getColumnIndexOrThrow(ApmAppFlowEntry.COLUMN_IS_BACKGROUND)
                val coreSessionIdIndex = cursor.getColumnIndexOrThrow(ApmAppFlowEntry.COLUMN_FIRST_CORE_SESSION_ID)

                val attributeKey = cursor.getColumnIndexOrThrow(ApmAppFlowTableAttributeEntry.COLUMN_KEY)
                val attributeValue = cursor.getColumnIndexOrThrow(ApmAppFlowTableAttributeEntry.COLUMN_VALUE)

                var currentFlowId: Long = -1
                var currentAttributes: HashMap<String, String>? = null

                do {
                    val flowId = cursor.getLong(idIndex)
                    if (currentFlowId != flowId) {
                        currentFlowId = flowId
                        currentAttributes = HashMap()
                        modelList += AppFlowCacheModel(
                            name = cursor.getString(nameIndex),
                            startTimeStampMicro = cursor.getLong(startTimeStampIndex),
                            startTimeMicro = cursor.getLong(startTimeIndex),
                            endTimeMicro = cursor.getLong(endTimeIndex).takeUnless { cursor.isNull(endTimeIndex) },
                            endReason = cursor.getInt(endReasonIndex),
                            isBackground = cursor.getBoolean(backgroundIndex),
                            firstCoreSessionId = cursor.getString(coreSessionIdIndex),
                            attributes = currentAttributes
                        )
                    }
                    cursor.getString(attributeKey)?.let { key ->
                        cursor.getString(attributeValue)?.let { value ->
                            currentAttributes?.put(key, value)
                        }
                    }
                } while (cursor.moveToNext())
            }
        }
}