package com.instabug.apm.appflow

import com.instabug.apm.appflow.handler.AppFlowHandler
import com.instabug.apm.common.concurrent.catchingExecuteAndGet
import com.instabug.apm.v3_session_data_readiness.APMSessionReadinessHandler
import com.instabug.apm.v3_session_data_readiness.SessionReadiness
import java.util.concurrent.ExecutorService

class AppFlowSessionReadinessHandler(
    private val executor: ExecutorService,
    private val handler: AppFlowHandler
) : APMSessionReadinessHandler {

    private var _hasBlockedSessions = false

    override fun handle(readiness: Map<String, SessionReadiness>) {
        executor.catchingExecuteAndGet {
            handler.filterUnReadyCoreSessionIds(readiness.keys.toList())
                ?.also { if (it.isNotEmpty()) _hasBlockedSessions = true }
                ?.forEach { readiness[it]?.markAsNotReady() }
        }
    }

    override val hasBlockedSessions: Boolean
        get() = _hasBlockedSessions
}