package com.instabug.apm.webview.webview_trace.model.event

import com.instabug.apm.model.EventTimeMetricCapture

class WebViewPostUrlEvent : WebViewEvent, WebViewTraceInitiationEvent {

    override val traceId: Long
    override val shouldInitiateNewTrace = false

    constructor(
        traceId: Long,
        timeCapture: EventTimeMetricCapture,
        copyCount: Int = 0
    ) : super(
        id = WebViewEventId.POST_URL,
        timeCapture = timeCapture,
        isTermination = true,
        copyCount = copyCount,
    ) {
        this.traceId = traceId
    }

    constructor(from: WebViewPostUrlEvent, isTerminationOverride: Boolean?) :
            super(from, isTerminationOverride) {
        this.traceId = from.traceId
    }

    override fun copy(isTerminationOverride: Boolean?): WebViewPostUrlEvent =
        WebViewPostUrlEvent(this, isTerminationOverride)
}