package com.instabug.apm.webview.webview_trace.model.event

import com.instabug.apm.model.EventTimeMetricCapture

class WebViewOverrideUrlEndEvent : WebViewEvent {

    val isUserTriggered: Boolean
    val isForceOverride: Boolean

    constructor(
        isUserTriggered: Boolean,
        isForceOverride: Boolean,
        timeCapture: EventTimeMetricCapture,
        copyCount: Int = 0
    ) : super(
        id = WebViewEventId.OVERRIDE_URL_END,
        timeCapture = timeCapture,
        isTermination = false,
        copyCount = copyCount
    ) {
        this.isUserTriggered = isUserTriggered
        this.isForceOverride = isForceOverride
    }

    constructor(
        from: WebViewOverrideUrlEndEvent,
        isTerminationOverride: Boolean? = null
    ) : super(from, isTerminationOverride) {
        this.isUserTriggered = from.isUserTriggered
        this.isForceOverride = from.isForceOverride
    }

    override fun shouldTerminateCurrentTrace(): Boolean {
        return super.shouldTerminateCurrentTrace() || isUserTriggered
    }

    override fun copy(isTerminationOverride: Boolean?): WebViewOverrideUrlEndEvent =
        WebViewOverrideUrlEndEvent(this, isTerminationOverride)
}