package com.instabug.apm.webview.webview_trace.model

import com.instabug.apm.model.EventTimeMetricCapture

data class WebViewTraceModel(
    val uiTraceId: Long,
    var url: String? = null,
    var firstEventTimeCapture: EventTimeMetricCapture? = null,
    var lastEventTimeCapture: EventTimeMetricCapture? = null,
    var isFullScreen: Boolean? = null,
    var vitals: MutableMap<String, Double>? = null
) {
    fun isSizeResolved() = isFullScreen != null

    fun isValid() =
        url != null &&
                firstEventTimeCapture != null &&
                lastEventTimeCapture != null &&
                isFullScreen != null
}
