package com.instabug.apm.webview.webview_trace

import com.instabug.apm.webview.webview_trace.model.WebViewCacheModel
import com.instabug.library.diagnostics.IBGDiagnostics
import com.instabug.library.map.Mapper
import org.json.JSONArray
import org.json.JSONObject

class WebViewCacheModelToJsonMapper : Mapper<List<WebViewCacheModel?>?, JSONArray?> {

    override fun map(from: List<WebViewCacheModel?>?): JSONArray? = runCatching {
        takeUnless { from.isNullOrEmpty() }?.let { JSONArray() }?.apply {
            from?.forEach { model -> put(model?.toJsonObject()) }
        }
    }.onFailure {
        IBGDiagnostics.reportNonFatal(it, "Error occurred while syncing WebViewTraces")
    }.getOrNull()

    private fun WebViewCacheModel.toJsonObject() = JSONObject().apply {
        put(WEB_VIEW_TRACE_SYNC_URL, url)
        put(WEB_VIEW_TRACE_SYNC_START_TIME_STAMP_MICROS, startTimeStampMicro)
        put(WEB_VIEW_TRACE_SYNC_DURATION_MICROS, durationMicro)
        put(WEB_VIEW_TRACE_SYNC_IS_FULL_SCREEN, isFulScreen)
        vitalsJsonObject?.takeIf { it.isNotBlank() }
            ?.let { put(WEB_VIEW_TRACE_SYNC_WEB_VITALS, JSONObject(it)) }
    }
}