package com.instabug.apm.webview.dispatch

import android.graphics.Bitmap
import android.net.http.SslError
import android.os.Build
import android.os.Message
import android.view.KeyEvent
import android.webkit.ClientCertRequest
import android.webkit.HttpAuthHandler
import android.webkit.RenderProcessGoneDetail
import android.webkit.SafeBrowsingResponse
import android.webkit.SslErrorHandler
import android.webkit.WebResourceError
import android.webkit.WebResourceRequest
import android.webkit.WebResourceResponse
import android.webkit.WebView
import android.webkit.WebViewClient
import androidx.annotation.RequiresApi
import com.instabug.library.transform.TransformationClass

private typealias Dispatcher = WebViewEventDispatcher

@TransformationClass
@RequiresApi(Build.VERSION_CODES.O)
class IbgWebViewClient(var delegate: WebViewClient? = null): WebViewClient() {

    private val id: Long = System.nanoTime()

    fun onLoadUrl(webView: WebView, url: String?) =
        Dispatcher.onLoadUrl(id, webView, url)

    fun onLoadUrl(
        webView: WebView,
        url: String?,
        headers: Map<String, String>?
    ) = Dispatcher.onLoadUrl(id, webView, url, headers)

    fun onPostUrl(webView: WebView, url: String?, postData: ByteArray?) =
        Dispatcher.onPostUrl(id, webView, url, postData)

    fun onLoadData(
        webView: WebView,
        data: String?,
        mimeType: String?,
        encoding: String?
    ) = Dispatcher.onLoadData(id, webView)

    fun onLoadDataWithBaseUrl(
        webView: WebView,
        baseUrl: String?,
        data: String?,
        encoding: String?,
        historyUrl: String?
    ) = Dispatcher.onLoadDataWithBaseUrl(id, webView)

    override fun shouldOverrideUrlLoading(view: WebView?, url: String?): Boolean {
        delegate?.let { return it.shouldOverrideUrlLoading(view, url) }
            ?: return super.shouldOverrideUrlLoading(view, url)
    }

    override fun shouldOverrideUrlLoading(view: WebView?, request: WebResourceRequest?): Boolean {
        Dispatcher.shouldOverrideUrlLoadingStarted(id, view, request)
        val override = ibgShouldOverrideUrlLoadingInternal(view, request)
        Dispatcher.shouldOverrideUrlLoadingEnded(id, view, request, override)
        return override
    }

    private fun ibgShouldOverrideUrlLoadingInternal(view: WebView?, request: WebResourceRequest?): Boolean {
        delegate?.let { return it.shouldOverrideUrlLoading(view, request) }
            ?: return super.shouldOverrideUrlLoading(view, request)
    }

    override fun onPageStarted(view: WebView?, url: String?, favicon: Bitmap?) {
        Dispatcher.onPageStarted(id, view, url, favicon)
        delegate?.onPageStarted(view, url, favicon)
            ?: super.onPageStarted(view, url, favicon)
    }

    override fun onPageFinished(view: WebView?, url: String?) {
        Dispatcher.onPageFinished(id, view, url)
        delegate?.onPageFinished(view, url)
            ?: super.onPageFinished(view, url)
    }

    override fun onLoadResource(view: WebView?, url: String?) {
        delegate?.onLoadResource(view, url)
            ?: super.onLoadResource(view, url)
    }

    override fun onPageCommitVisible(view: WebView?, url: String?) {
        delegate?.onPageCommitVisible(view, url)
            ?: super.onPageCommitVisible(view, url)
    }

    override fun shouldInterceptRequest(view: WebView?, url: String?): WebResourceResponse? {
        delegate?.let { return it.shouldInterceptRequest(view, url) }
            ?: return super.shouldInterceptRequest(view, url)
    }

    override fun shouldInterceptRequest(
        view: WebView?,
        request: WebResourceRequest?
    ): WebResourceResponse? {
        delegate?.let { return it.shouldInterceptRequest(view, request) }
            ?: return super.shouldInterceptRequest(view, request)
    }

    override fun onTooManyRedirects(view: WebView?, cancelMsg: Message?, continueMsg: Message?) {
        delegate?.onTooManyRedirects(view, cancelMsg, continueMsg)
            ?: super.onTooManyRedirects(view, cancelMsg, continueMsg)
    }

    override fun onReceivedError(
        view: WebView?,
        errorCode: Int,
        description: String?,
        failingUrl: String?
    ) {
        delegate?.onReceivedError(view, errorCode, description, failingUrl)
            ?: super.onReceivedError(view, errorCode, description, failingUrl)
    }

    override fun onReceivedError(
        view: WebView?,
        request: WebResourceRequest?,
        error: WebResourceError?
    ) {
        Dispatcher.onReceivedError(id, view, request, error)
        delegate?.onReceivedError(view, request, error)
            ?: super.onReceivedError(view, request, error)
    }

    override fun onReceivedHttpError(
        view: WebView?,
        request: WebResourceRequest?,
        errorResponse: WebResourceResponse?
    ) {
        Dispatcher.onReceivedHttpError(id, view, request, errorResponse)
        delegate?.onReceivedHttpError(view, request, errorResponse)
            ?: super.onReceivedHttpError(view, request, errorResponse)
    }

    override fun onFormResubmission(view: WebView?, dontResend: Message?, resend: Message?) {
        delegate?.onFormResubmission(view, dontResend, resend)
            ?: super.onFormResubmission(view, dontResend, resend)
    }

    override fun doUpdateVisitedHistory(view: WebView?, url: String?, isReload: Boolean) {
        delegate?.doUpdateVisitedHistory(view, url, isReload)
            ?: super.doUpdateVisitedHistory(view, url, isReload)
    }

    override fun onReceivedSslError(view: WebView?, handler: SslErrorHandler?, error: SslError?) {
        delegate?.onReceivedSslError(view, handler, error)
            ?: super.onReceivedSslError(view, handler, error)
    }

    override fun onReceivedClientCertRequest(view: WebView?, request: ClientCertRequest?) {
        delegate?.onReceivedClientCertRequest(view, request)
            ?: super.onReceivedClientCertRequest(view, request)
    }

    override fun onReceivedHttpAuthRequest(
        view: WebView?,
        handler: HttpAuthHandler?,
        host: String?,
        realm: String?
    ) {
        delegate?.onReceivedHttpAuthRequest(view, handler, host, realm)
            ?: super.onReceivedHttpAuthRequest(view, handler, host, realm)
    }

    override fun shouldOverrideKeyEvent(view: WebView?, event: KeyEvent?): Boolean {
        delegate?.let { return it.shouldOverrideKeyEvent(view, event) }
            ?: return super.shouldOverrideKeyEvent(view, event)
    }

    override fun onUnhandledKeyEvent(view: WebView?, event: KeyEvent?) {
        delegate?.onUnhandledKeyEvent(view, event)
            ?: super.onUnhandledKeyEvent(view, event)
    }

    override fun onScaleChanged(view: WebView?, oldScale: Float, newScale: Float) {
        delegate?.onScaleChanged(view, oldScale, newScale)
            ?: super.onScaleChanged(view, oldScale, newScale)
    }

    override fun onReceivedLoginRequest(
        view: WebView?,
        realm: String?,
        account: String?,
        args: String?
    ) {
        delegate?.onReceivedLoginRequest(view, realm, account, args)
            ?: super.onReceivedLoginRequest(view, realm, account, args)
    }

    override fun onRenderProcessGone(view: WebView?, detail: RenderProcessGoneDetail?): Boolean {
        delegate?.let { return it.onRenderProcessGone(view, detail) }
            ?: return super.onRenderProcessGone(view, detail)
    }

    @RequiresApi(Build.VERSION_CODES.O_MR1)
    override fun onSafeBrowsingHit(
        view: WebView?,
        request: WebResourceRequest?,
        threatType: Int,
        callback: SafeBrowsingResponse?
    ) {
        delegate?.onSafeBrowsingHit(view, request, threatType, callback)
            ?: super.onSafeBrowsingHit(view, request, threatType, callback)
    }
}