package com.instabug.apm.networking.handler;

import androidx.annotation.NonNull;

import com.instabug.apm.cache.model.SessionCacheModel;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Request;

import java.util.List;

public interface SyncManagerNetworkHandler {

    /**
     * Sync sessions list of {@link SessionCacheModel} with the BE
     *
     * @param sessions sessions list to be synced
     * @param callback a network callback to notify caller by request status when finished
     */
    void syncSessions(@NonNull List<SessionCacheModel> sessions,
                      Request.Callbacks<RequestResponse, Throwable> callback);
}
