package com.instabug.apm.model;

import androidx.annotation.Nullable;

/**
 * A builder class for the public {@link NetworkTrace}
 */
public class NetworkTraceBuilder {

    @Nullable
    private Long startTime;
    @Nullable
    private String url;
    @Nullable
    private String requestHeaders;
    @Nullable
    private String responseHeaders;
    @Nullable
    private String requestContentType;
    @Nullable
    private String responseContentType;
    @Nullable
    private String errorMessage;
    @Nullable
    private String radio;
    @Nullable
    private String carrier;
    @Nullable
    private String responseBody;
    @Nullable
    private String requestBody;
    @Nullable
    private String method = "get";
    private long requestBodySize;
    private long responseBodySize;
    private int responseCode;
    private long totalDuration;

    public NetworkTraceBuilder startTime(@Nullable Long startTime) {
        this.startTime = startTime;
        return this;
    }

    public NetworkTraceBuilder url(@Nullable String url) {
        this.url = url;
        return this;
    }

    public NetworkTraceBuilder requestHeaders(@Nullable String requestHeaders) {
        this.requestHeaders = requestHeaders;
        return this;
    }

    public NetworkTraceBuilder responseHeaders(@Nullable String responseHeaders) {
        this.responseHeaders = responseHeaders;
        return this;
    }

    public NetworkTraceBuilder requestContentType(@Nullable String requestContentType) {
        this.requestContentType = requestContentType;
        return this;
    }

    public NetworkTraceBuilder responseContentType(@Nullable String responseContentType) {
        this.responseContentType = responseContentType;
        return this;
    }

    public NetworkTraceBuilder errorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public NetworkTraceBuilder radio(@Nullable String radio) {
        this.radio = radio;
        return this;
    }

    public NetworkTraceBuilder carrier(@Nullable String carrier) {
        this.carrier = carrier;
        return this;
    }

    public NetworkTraceBuilder responseBody(@Nullable String responseBody) {
        this.responseBody = responseBody;
        return this;
    }

    public NetworkTraceBuilder requestBody(@Nullable String requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public NetworkTraceBuilder method(@Nullable String method) {
        this.method = method;
        return this;
    }

    public NetworkTraceBuilder totalDuration(long totalDuration) {
        this.totalDuration = totalDuration;
        return this;
    }

    public NetworkTraceBuilder responseCode(int responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public NetworkTraceBuilder requestBodySize(long requestBodySize) {
        this.requestBodySize = requestBodySize;
        return this;
    }

    public NetworkTraceBuilder responseBodySize(long responseBodySize) {
        this.responseBodySize = responseBodySize;
        return this;
    }

    public NetworkTrace build() {
        NetworkTrace NetworkTrace = new NetworkTrace();
        NetworkTrace.setCarrier(carrier);
        NetworkTrace.setErrorMessage(errorMessage);
        NetworkTrace.setMethod(method);
        NetworkTrace.setRadio(radio);
        NetworkTrace.setRequestBody(requestBody);
        NetworkTrace.setRequestBodySize(requestBodySize);
        NetworkTrace.setRequestContentType(requestContentType);
        NetworkTrace.setRequestHeaders(requestHeaders);
        NetworkTrace.setResponseBody(responseBody);
        NetworkTrace.setResponseBodySize(responseBodySize);
        NetworkTrace.setResponseCode(responseCode);
        NetworkTrace.setResponseContentType(responseContentType);
        NetworkTrace.setResponseHeaders(responseHeaders);
        NetworkTrace.setStartTime(startTime);
        NetworkTrace.setTotalDuration(totalDuration);
        NetworkTrace.setUrl(url);
        return NetworkTrace;
    }
}
