package com.instabug.apm.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Public APM Network Trace
 */
public class NetworkTrace {
    @Nullable
    private Long startTime;
    @Nullable
    private String url;
    @Nullable
    private String requestHeaders;
    @Nullable
    private String responseHeaders;
    @Nullable
    private String requestContentType;
    @Nullable
    private String responseContentType;
    @Nullable
    private String errorMessage;
    @Nullable
    private String radio;
    @Nullable
    private String carrier;
    @Nullable
    private String responseBody;
    @Nullable
    private String requestBody;
    @Nullable
    private String method = "get";
    private long totalDuration;
    private int responseCode;
    private long requestBodySize;
    private long responseBodySize;

    @Nullable
    public Long getStartTime() {
        return startTime;
    }

    protected void setStartTime(@Nullable Long startTime) {
        this.startTime = startTime;
    }

    @Nullable
    public String getUrl() {
        return url;
    }

    protected void setUrl(@Nullable String url) {
        this.url = url;
    }

    @Nullable
    public String getMethod() {
        return method;
    }

    protected void setMethod(@Nullable String method) {
        this.method = method;
    }

    @Nullable
    public String getRequestHeaders() {
        return requestHeaders;
    }

    protected void setRequestHeaders(@Nullable String requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @Nullable
    public String getResponseHeaders() {
        return responseHeaders;
    }

    protected void setResponseHeaders(@Nullable String responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    @Nullable
    public String getRequestContentType() {
        return requestContentType;
    }

    protected void setRequestContentType(@Nullable String requestContentType) {
        this.requestContentType = requestContentType;
    }

    @Nullable
    public String getResponseContentType() {
        return responseContentType;
    }

    protected void setResponseContentType(@Nullable String responseContentType) {
        this.responseContentType = responseContentType;
    }

    @Nullable
    public String getErrorMessage() {
        return errorMessage;
    }

    protected void setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
    }

    // SDK Protected Setters

    @Nullable
    public String getRadio() {
        return radio;
    }

    protected void setRadio(@Nullable String radio) {
        this.radio = radio;
    }

    @Nullable
    public String getCarrier() {
        return carrier;
    }

    protected void setCarrier(@Nullable String carrier) {
        this.carrier = carrier;
    }

    public long getTotalDuration() {
        return totalDuration;
    }

    protected void setTotalDuration(long totalDuration) {
        this.totalDuration = totalDuration;
    }

    public int getResponseCode() {
        return responseCode;
    }

    protected void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public long getRequestBodySize() {
        return requestBodySize;
    }

    protected void setRequestBodySize(long requestBodySize) {
        this.requestBodySize = requestBodySize;
    }

    public long getResponseBodySize() {
        return responseBodySize;
    }

    protected void setResponseBodySize(long responseBodySize) {
        this.responseBodySize = responseBodySize;
    }

    @Nullable
    public String getRequestBody() {
        return requestBody;
    }

    protected void setRequestBody(@Nullable String requestBody) {
        this.requestBody = requestBody;
    }

    @Nullable
    public String getResponseBody() {
        return responseBody;
    }

    protected void setResponseBody(@Nullable String responseBody) {
        this.responseBody = responseBody;
    }

    @NonNull
    @Override
    public String toString() {
        return "APMNetworkLog{" +
                "url = " + url + ", \n" +
                "method = " + method + ", \n" +
                "startTime = " + startTime + ", \n" +
                "radio = " + radio + ", \n" +
                "carrier = " + carrier + ", \n" +
                "totalDuration = " + totalDuration + ", \n" +
                "responseCode = " + responseCode + ", \n" +
                "errorMessage = " + errorMessage + ", \n" +
                "requestHeaders = " + requestHeaders + ", \n" +
                "requestContentType = " + requestContentType + ", \n" +
                "requestBodySize = " + requestBodySize + ", \n" +
                "requestBody = " + requestBody + ", \n" +
                "responseHeaders = " + responseHeaders + ", \n" +
                "responseContentType = " + responseContentType + ", \n" +
                "responseBodySize = " + responseBodySize + ", \n" +
                "responseBody = " + responseBody +
                '}';
    }
}


