package com.instabug.apm.constants;

public interface APMConfigurationKeys {

    String KEY_APM_SHARED_PREFERENCES = "instabug_apm";
    String KEY_IS_APM_FEATURE_AVAILABLE = "IS_APM_FEATURE_AVAILABLE";
    String KEY_IS_APM_SDK_ENABLED = "IS_APM_SDK_ENABLED";
    String KEY_SYNC_INTERVAL = "SYNC_INTERVAL";
    String KEY_LAST_SYNC_TIME = "LAST_SYNC_TIME";
    String KEY_DISABLED_SDK_VERSIONS = "KEY_DISABLED_SDK_VERSIONS";
    String KEY_CRASH_DETECTION_ENABLED = "CRASH_DETECTION_ENABLED";
    String KEY_DEBUG_MODE_ENABLED = "DEBUG_MODE_ENABLED";
    String KEY_SESSION_STARTED_AT = "SESSION_STARTED_AT";
    String KEY_SESSION_STORE_LIMIT_ENABLED = "SESSION_STORE_LIMIT_ENABLED";
    String KEY_SESSION_STORE_LIMIT = "SESSION_STORE_LIMIT";
    String KEY_DROPPED_SESSION_COUNT_STORE_LIMIT = "DROPPED_SESSION_COUNT_STORE_LIMIT";
    String KEY_SHOULD_DEPEND_ON_V3_SESSION = "SHOULD_DEPEND_ON_V3_SESSION";
    String KEY_SHOULD_SEND_LEGACY_SESSIONS = "SHOULD_SEND_LEGACY_APM_SESSIONS";

    interface Launches {
        String KEY_LAUNCHES_ENABLED = "LAUNCHES_ENABLED";
        String KEY_HOT_LAUNCHES_ENABLED = "HOT_LAUNCHES_ENABLED";
        String KEY_COLD_LAUNCHES_PER_REQUEST_LIMIT = "COLD_LAUNCHES_PER_REQUEST_LIMIT";
        String KEY_COLD_LAUNCHES_STORE_LIMIT = "COLD_LAUNCHES_STORE_LIMIT";
        String KEY_COLD_LAUNCHES_SDK_ENABLED = "COLD_LAUNCHES_SDK_ENABLED";
        String KEY_HOT_LAUNCHES_PER_REQUEST_LIMIT = "HOT_LAUNCHES_PER_REQUEST_LIMIT";
        String KEY_HOT_LAUNCHES_STORE_LIMIT = "HOT_LAUNCHES_STORE_LIMIT";
        String KEY_HOT_LAUNCHES_SDK_ENABLED = "HOT_LAUNCHES_SDK_ENABLED";
        String KEY_END_COLD_APP_LAUNCH_ENABLED = "END_COLD_APP_LAUNCH_ENABLED";
        String KEY_END_HOT_APP_LAUNCH_ENABLED = "END_HOT_APP_LAUNCH_ENABLED";
        String KEY_WARM_APP_LAUNCH_ENABLED = "WARM_APP_LAUNCH_ENABLED";
        String KEY_WARM_APP_LAUNCH_PER_REQUEST_LIMIT = "WARM_APP_LAUNCHES_PER_REQUEST_LIMIT";
        String KEY_WARM_APP_LAUNCH_STORE_LIMIT = "WARM_APP_LAUNCHES_STORE_LIMIT";
        String KEY_END_WARM_APP_LAUNCH_ENABLED = "END_WARM_APP_LAUNCH_ENABLED";
        String KEY_WARM_APP_LAUNCH_SDK_ENABLED = "WARM_LAUNCHES_SDK_ENABLED";
    }

    interface Network {
        String KEY_NETWORK_ENABLED = "NETWORK_ENABLED";
        String KEY_NETWORK_LOGS_REQUEST_LIMIT = "NETWORK_LOGS_REQUEST_LIMIT";
        String KEY_NETWORK_LOGS_CACHE_LIMIT = "NETWORK_LOGS_CACHE_LIMIT";
        String KEY_NETWORK_LOGS_LAST_SYNC_TIME = "NETWORK_LOGS_LAST_SYNC_TIME";
        String KEY_ATTRIBUTES_COUNT = "NETWORK_LOGS_ATTRIBUTES_COUNT";
        String KEY_NETWORK_GRAPH_QL_ENABLED = "NETWORK_GRAPHQL_ENABLED";
        String KEY_NETWORK_GRPC_ENABLED = "NETWORK_GRPC_ENABLED";
    }

    interface UiTraces {
        String KEY_UI_TRACE_SDK_ENABLED = "UI_TRACE_SDK_ENABLED";
        String KEY_UI_TRACE_LIMIT_PER_REQUEST = "KEY_UI_TRACE_LIMIT_PER_REQUEST";
        String KEY_UI_TRACE_STORE_LIMIT = "KEY_UI_TRACE_STORE_LIMIT";
        String KEY_UI_TRACE_LARGE_DROP_THRESHOLD = "UI_TRACE_LARGE_DROP_THRESHOLD";
        String KEY_UI_TRACE_SMALL_DROP_THRESHOLD = "UI_TRACE_SMALL_DROP_THRESHOLD";
    }

    interface UiHangs {

        // it has UI_TRACE_ENABLED value instead of UI_HANG_ENABLED for backwards compatibility
        String KEY_UI_HANG_ENABLED = "UI_TRACE_ENABLED";
        String KEY_UI_HANG_SDK_ENABLED = "UI_HANG_SDK_ENABLED";
    }

    interface UiLoadingMetrics {
        String KEY_UI_LOADING_ENABLED = "UI_LOADING_ENABLED";
        String KEY_UI_LOADING_SDK_ENABLED = "UI_LOADING_SDK_ENABLED";
        String KEY_END_SCREEN_LOADING_ENABLED = "END_SCREEN_LOADING_ENABLED";
    }

    interface RateLimitation {
        String LAST_APM_SESSIONS_REQUEST_STARTED_AT = "last_apm_sessions_request_started_at";
        String APM_SESSIONS_LIMITED_UNTIL = "apm_sessions_rate_limited_until";
    }

    interface FragmentSpans {
        String KEY_FRAGMENT_SPANS_ENABLED = "FRAGMENT_SPANS_ENABLED";
        String KEY_FRAGMENT_SPANS_SDK_ENABLED = "FRAGMENT_SPANS_SDK_ENABLED";
        String KEY_FRAGMENT_SPANS_STORE_LIMIT = "FRAGMENT_SPANS_STORE_LIMIT";
        String KEY_FRAGMENT_SPANS_LIMIT_PER_REQUEST = "FRAGMENT_SPANS_LIMIT_PER_REQUEST";
    }
}
