package com.instabug.apm.configuration.cp

import com.instabug.apm.di.ServiceLocator
import com.instabug.apm.networking.ApmNetworkInterceptorHelper
import com.instabug.apm.networkinterception.configuration.DEFAULT_CP_NATIVE_INTERCEPTION_ENABLED
import com.instabug.apm.screenloading.di.ScreenLoadingServiceLocator

fun interface FeatureAvailabilityCallback {
    operator fun invoke(isFeatureAvailable: Boolean)
}

object APMCPConfigurationProvider {

    fun getFeatureAvailability(
        @APMFeature feature: String,
        apiName: String,
        callback: FeatureAvailabilityCallback,
    ) = ServiceLocator.getIOExecutor().execute {
        callback(checkAvailability(feature, apiName))
    }

    fun getFeatureAvailability(
        @APMFeature feature: String,
        apiName: String
    ) = checkAvailability(feature, apiName)

    private fun checkAvailability(@APMFeature feature: String, apiName: String): Boolean =
        when (feature) {
            APMFeature.SCREEN_LOADING -> ScreenLoadingServiceLocator
                .ScreenLoadingFeatureAvailabilityChecker.isAvailable(apiName)

            APMFeature.NETWORK_INTERCEPTION_ENABLED ->
                ServiceLocator.getApmConfigurationProvider().isNetworkEnabled

            APMFeature.CP_NATIVE_INTERCEPTION_ENABLED ->
                ServiceLocator.getNetworkInterceptionConfigurationProvider()?.isCPNativeInterceptionEnabled
                    ?: DEFAULT_CP_NATIVE_INTERCEPTION_ENABLED

            APMFeature.APM_NETWORK_PLUGIN_INSTALLED ->
                ApmNetworkInterceptorHelper.isPluginFlagEnabled

            else -> false
        }
}