package com.instabug.apm.appflow.validate

import com.instabug.apm.appflow.configuration.AppFlowConfigurationProvider
import com.instabug.apm.appflow.log.logAPMSdkDisabled
import com.instabug.apm.appflow.log.logFeatureBEDisabled
import com.instabug.apm.configuration.APMConfigurationProvider
import com.instabug.apm.logger.internal.Logger
import com.instabug.apm.sanitization.Validator

open class ConfigurationsValidator(
    protected val apiName: String,
    protected val apmConfigurations: APMConfigurationProvider,
    protected val appFLowConfigurations: AppFlowConfigurationProvider,
    protected val logger: Logger
): Validator<Unit> {

    override fun isValid(item: Unit): Boolean =
        when {
            !apmConfigurations.isAPMSdkEnabled -> {
                logger.logAPMSdkDisabled(apiName)
                false
            }
            !(apmConfigurations.isAPMFeatureAvailable && appFLowConfigurations.featureEnabled) -> {
                logger.logFeatureBEDisabled(apiName)
                false
            }
            else -> true
        }
}