package com.instabug.apm.appflow.map

import android.content.ContentValues
import com.instabug.apm.appflow.model.AppFlowInsertionCacheModel
import com.instabug.library.internal.storage.cache.db.contract.apm.ApmAppFlowEntry
import com.instabug.library.map.Mapper

class AppFlowContentValuesMapper : Mapper<AppFlowInsertionCacheModel, ContentValues> {

    override fun map(from: AppFlowInsertionCacheModel): ContentValues =
        ContentValues().apply {
            put(ApmAppFlowEntry.COLUMN_NAME, from.name)
            put(ApmAppFlowEntry.COLUMN_START_TIMESTAMP_MU, from.timeStampMicro)
            put(ApmAppFlowEntry.COLUMN_START_TIME_MU, from.timeMicro)
            put(ApmAppFlowEntry.COLUMN_APP_LAUNCH_ID, from.appLaunchId)
            put(ApmAppFlowEntry.COLUMN_APM_SESSION_ID, from.apmSessionId)
            put(ApmAppFlowEntry.COLUMN_FIRST_CORE_SESSION_ID, from.coreSessionId)
            put(ApmAppFlowEntry.COLUMN_IS_BACKGROUND, from.isBackground)
        }
}