package com.instabug.apm.util

import com.instabug.apm.di.ServiceLocator
import com.instabug.library.Platform
import com.instabug.library.settings.SettingsManager

private val currentPlatform: Int
    get() = SettingsManager.getInstance().let { settingsManager ->
        ServiceLocator.getContext()
            ?.let(settingsManager::getEarlyCurrentPlatform)
            ?: settingsManager.currentPlatform
    }

val isCurrentPlatformCP
    get() = currentPlatform != Platform.ANDROID
