package com.instabug.apm.uitrace.activitycallbacks;

import android.app.Activity;
import android.os.Bundle;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.apm.model.EventTimeMetricCapture;

public interface APMUiTraceActivityCallbacks {
    @MainThread
    default void onActivityPreCreated(
            @NonNull Activity activity,
            @Nullable Bundle savedInstanceState,
            @NonNull EventTimeMetricCapture timeMetric,
            long uiTraceId
    ) {
    }

    @MainThread
    default void onActivityCreated(
            @NonNull Activity activity,
            @Nullable Bundle savedInstanceState,
            @NonNull EventTimeMetricCapture timeMetric,
            long uiTraceId
    ) {
    }

    @MainThread
    default void onActivityPostCreated(
            @NonNull Activity activity,
            @Nullable Bundle savedInstanceState,
            @NonNull EventTimeMetricCapture timeMetric
    ) {
    }

    @MainThread
    default void onActivityPreStarted(@NonNull Activity activity, @NonNull EventTimeMetricCapture timeMetric) {
    }

    @MainThread
    default void onActivityStarted(@NonNull Activity activity, @NonNull EventTimeMetricCapture timeMetric) {
    }

    @MainThread
    default void onActivityPostStarted(@NonNull Activity activity, @NonNull EventTimeMetricCapture timeMetric) {
    }

    @MainThread
    default void onActivityPreResumed(@NonNull Activity activity, @NonNull EventTimeMetricCapture timeMetric) {
    }

    @MainThread
    default void onActivityResumed(
            @NonNull Activity activity,
            @NonNull EventTimeMetricCapture timeMetric,
            long uiTraceId
    ) {
    }

    @MainThread
    default void onActivityPostResumed(@NonNull Activity activity, @NonNull EventTimeMetricCapture timeMetric) {
    }

    @MainThread
    default void onActivityPaused(@NonNull Activity activity, @NonNull EventTimeMetricCapture timeMetric) {
    }

    @MainThread
    default void onActivityStopped(@NonNull Activity activity, boolean isAppInBackground) {
    }

    @MainThread
    default void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
    }

    @MainThread
    default void onActivityDestroyed(@NonNull Activity activity) {
    }

    default void observeAPMSessions() {
    }

    default void stopObservingAPMSessions() {
    }

}
