package com.instabug.apm.networkinterception

import java.io.IOException
import java.net.HttpURLConnection
import java.net.URL
import java.net.URLConnection
import javax.net.ssl.HttpsURLConnection
import kotlin.jvm.Throws
import com.instabug.apm.networking.ApmNetworkInterceptorHelper

object URLConnectionHandler {

    private val isValidToIntercept
        get() = ApmNetworkInterceptorHelper.isUrlConnectionInterceptionEnabled

    @Throws(IOException::class)
    @JvmStatic
    fun openConnection(url: URL): URLConnection = url.openConnection()
        .let { if (isValidToIntercept) getUrlConnection(it) else it }

    private fun getUrlConnection(connection: URLConnection): URLConnection = when (connection) {
        is HttpsURLConnection -> APMHttpsUrlConnection(connection)
        is HttpURLConnection -> APMHttpUrlConnection(connection)
        else -> connection
    }
}
