package com.instabug.apm.networking

import com.instabug.apm.di.ServiceLocator
import com.instabug.apm.networkinterception.configuration.NetworkInterceptionConfigurationProvider

object ApmNetworkInterceptorHelper {

    private val networkInterceptionConfigurationProvider: NetworkInterceptionConfigurationProvider?
        get() = ServiceLocator.getNetworkInterceptionConfigurationProvider()

    @JvmStatic
    val isPluginFlagEnabled: Boolean = false

    val isNetworkSpansEnabled: Boolean
        get() = networkInterceptionConfigurationProvider?.isNetworkSpansEnabled ?: false

    @JvmStatic
    fun isNativeInterceptionEnabled(): Boolean =
        networkInterceptionConfigurationProvider?.isNativeInterceptionEnabled ?: false


    @JvmStatic
    fun isGraphQlEnabled(): Boolean =
        ServiceLocator.getApmConfigurationProvider().isNetworkGraphQlFeatureEnabled

    @JvmStatic
    fun isGrpcInterceptionEnabled(): Boolean =
        networkInterceptionConfigurationProvider?.isGrpcInterceptionEnabled ?: false

    @JvmStatic
    val isUrlConnectionInterceptionEnabled: Boolean
        get() = networkInterceptionConfigurationProvider?.isUrlConnectionInterceptionEnabled
            ?: false
}
