package com.instabug.apm.handler.session;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.apm.di.ServiceLocator;
import com.instabug.library.model.common.Session;

public final class SessionObserverHandler {

    private SessionObserverHandler() {
    }

    public static void register(@NonNull APMSessionObserver observer) {
        ServiceLocator.getSessionObserverRegistry().register(observer);
    }

    public static void unregister(@NonNull APMSessionObserver observer) {
        ServiceLocator.getSessionObserverRegistry().unregister(observer);
    }

    static void notifyNewSessionStarted(@NonNull Session runningSession, @Nullable Session lastSession) {
        for (APMSessionObserver observer : ServiceLocator.getSessionObserverRegistry().getObservers()) {
            observer.onNewSessionStarted(runningSession, lastSession);
        }
    }
}
