package com.instabug.apm.handler.session;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.model.common.Session;

public interface APMSessionObserver {

    /**
     * Gets fired whenever a new session starts
     *
     * @param runningSession the currently active session
     * @param lastSession    the most recently ended session (if any)
     */
    void onNewSessionStarted(@NonNull Session runningSession, @Nullable Session lastSession);
}
