package com.instabug.apm.compose.compose_spans

import com.instabug.apm.cache.model.SessionCacheModel
import com.instabug.apm.compose.compose_spans.model.ComposeSpansCacheModel
import com.instabug.apm.compose.compose_spans.model.transform.COMPOSE_SPANS_ARRAY_KEY
import com.instabug.apm.compose.compose_spans.model.transform.COMPOSE_SPANS_KEY
import com.instabug.apm.compose.compose_spans.model.transform.DROPPED_REQUEST_LIMIT_KEY
import com.instabug.apm.compose.compose_spans.model.transform.DROPPED_STORE_LIMIT_KEY
import com.instabug.apm.networking.mapping.sessions.SessionFeatureJsonFiller
import com.instabug.library.map.Mapper
import org.json.JSONArray
import org.json.JSONObject

class SessionComposeSpansJsonFiller(
    private val mapper: Mapper<List<ComposeSpansCacheModel>?, JSONArray?>
) : SessionFeatureJsonFiller {

    override fun addToJsonObject(model: SessionCacheModel, sessionJsonObject: JSONObject) {
        model.sessionMetaData?.takeIf { it.composeSpansTotalCount > 0 }
            ?.let { metadata ->
                val featureJsonObject = JSONObject()
                val spansModel = model.composeSpans
                val storedCount = spansModel?.size ?: 0
                metadata.getComposeSpansDroppedCountStoreLimit(storedCount)
                    .takeIf { it > 0 }
                    ?.let { featureJsonObject.put(DROPPED_STORE_LIMIT_KEY, it) }
                metadata.composeSpansDroppedCountRequestLimit
                    .takeIf { it > 0 }
                    ?.let { featureJsonObject.put(DROPPED_REQUEST_LIMIT_KEY, it) }
                mapper.map(spansModel)?.let { spansJsonArray ->
                    featureJsonObject.put(COMPOSE_SPANS_ARRAY_KEY, spansJsonArray)
                }
                sessionJsonObject.put(COMPOSE_SPANS_KEY, featureJsonObject)
            }
    }
}