package com.instabug.apm.appflow.map

import com.instabug.apm.appflow.model.AppFlowCacheModel
import com.instabug.apm.appflow.model.AppFlowEndReason
import com.instabug.library.map.Mapper
import org.json.JSONArray
import org.json.JSONObject

class AppFlowJsonMapper : Mapper<List<AppFlowCacheModel>?, JSONArray?> {

    companion object {
        private const val BACKGROUND_KEY = "bg"
        private const val NAME_KEY = "n"
        private const val START_TIME_KEY = "st"
        private const val DURATION_KEY = "dmus"
        private const val ATTRIBUTES_KEY = "att"
        private const val IS_FLOW_KEY = "if"
        private const val END_REASON_KEY = "er"
        private const val FIRST_CORE_SESSION_KEY = "fsid"
        
        private const val END_REASON_ABANDONMENT = "abandonment"
        private const val END_REASON_FORCE_ABANDONMENT = "force_abandonment"
    }

    override fun map(from: List<AppFlowCacheModel>?): JSONArray? =
        from?.takeIf { it.isNotEmpty() }
            ?.map(::map)
            ?.let { JSONArray(it) }

    private fun map(from: AppFlowCacheModel): JSONObject =
        JSONObject().apply {
            put(BACKGROUND_KEY, from.isBackground)
            put(NAME_KEY, from.name)
            put(START_TIME_KEY, from.startTimeStampMicro)
            put(IS_FLOW_KEY, true)
            put(FIRST_CORE_SESSION_KEY, from.firstCoreSessionId)
            from.durationMicro?.let { put(DURATION_KEY, it) }
                ?: let { from.endReasonString() }?.let { put(END_REASON_KEY, it) }
            from.attributes.takeIf { it.isNotEmpty() }
                ?.let { put(ATTRIBUTES_KEY, JSONObject(it)) }

        }

    private fun AppFlowCacheModel.endReasonString(): String? =
        when (endReason) {
            AppFlowEndReason.ABANDONMENT -> END_REASON_ABANDONMENT
            AppFlowEndReason.FORCE_ABANDONMENT -> END_REASON_FORCE_ABANDONMENT
            else -> null
        }
}