package com.instabug.apm.appflow.log

import com.instabug.apm.logger.internal.Logger

internal fun Logger.logFeatureBEDisabled(apiName: String) =
    e(FEATURE_BE_DISABLED.replace(PLACE_HOLDER, apiName))

internal fun Logger.logAPMSdkDisabled(apiName: String) =
    e(APM_SDK_DISABLED.replace(PLACE_HOLDER, apiName))

internal fun Logger.logForceAbandonedFlow(name: String) =
    e(FORCE_ABANDONED_FLOW.replace(PLACE_HOLDER, name))

internal fun Logger.logFlowNotEndedNoMatchingActiveFlow(name: String) =
    e(FLOW_NOT_ENDED_NO_MATCHING_FLOW.replace(PLACE_HOLDER, name))

internal fun Logger.logAttributeWasNotAddedNoMatchingActiveFlow(name: String) =
    e(ATTRIBUTE_NOT_ADDED_NO_MATCHING_FLOW.replace(PLACE_HOLDER, name))

internal fun Logger.logFlowNameIsNullOrEmpty() =
    e(FLOW_NAME_IS_NULL_OR_EMPTY)

internal fun Logger.logFlowNameTruncated(name: String) =
    w(FLOW_NAME_TRUNCATED.replace(PLACE_HOLDER, name))

internal fun Logger.logAttributeKeyExceededMaxLength(flowName: String?, key: String?) =
    e(
        ATTRIBUTE_KEY_EXCEEDED_MAX_LENGTH
            .replace("${PLACE_HOLDER}1", key ?: "")
            .replace("${PLACE_HOLDER}2", flowName ?: "")
    )

internal fun Logger.logAttributeValueExceededMaxLength(flowName: String?, key: String?) =
    e(
        ATTRIBUTE_VALUE_EXCEEDED_MAX_LENGTH
            .replace("${PLACE_HOLDER}1", key ?: "")
            .replace("${PLACE_HOLDER}2", flowName ?: "")
    )

internal fun Logger.logAttributeValueIsEmpty(flowName: String?, key: String?) =
    e(
        ATTRIBUTE_VALUE_IS_EMPTY
            .replace("${PLACE_HOLDER}1", key ?: "")
            .replace("${PLACE_HOLDER}2", flowName ?: "")
    )

internal fun Logger.logAttributeKeyIsNullOrEmpty(flowName: String?) =
    e(ATTRIBUTE_KEY_IS_NULL.replace(PLACE_HOLDER, flowName ?: ""))

internal fun Logger.logAttributesExceededMaxAllowedCount(
    flowName: String?,
    key: String?,
    maxCount: Int
) = e(
    ATTRIBUTE_EXCEEDED_STORE_LIMIT
        .replace("${PLACE_HOLDER}1", key ?: "")
        .replace("${PLACE_HOLDER}2", flowName ?: "")
        .replace("${PLACE_HOLDER}3", maxCount.toString())
)

internal fun Logger.logDroppedFlows(dropCount: Int) =
    d(DROPPED_FLOW_COUNT.replace(PLACE_HOLDER, dropCount.toString()))

